// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// The HomeNetworkPrivateKeysProvisioning.
    /// Serialized Name: HomeNetworkPrivateKeysProvisioning
    /// </summary>
    internal partial class HomeNetworkPrivateKeysProvisioning
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HomeNetworkPrivateKeysProvisioning"/>. </summary>
        /// <param name="state">
        /// The provisioning state of the private keys for SUPI concealment.
        /// Serialized Name: HomeNetworkPrivateKeysProvisioning.state
        /// </param>
        internal HomeNetworkPrivateKeysProvisioning(HomeNetworkPrivateKeysProvisioningState state)
        {
            State = state;
        }

        /// <summary> Initializes a new instance of <see cref="HomeNetworkPrivateKeysProvisioning"/>. </summary>
        /// <param name="state">
        /// The provisioning state of the private keys for SUPI concealment.
        /// Serialized Name: HomeNetworkPrivateKeysProvisioning.state
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HomeNetworkPrivateKeysProvisioning(HomeNetworkPrivateKeysProvisioningState state, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            State = state;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="HomeNetworkPrivateKeysProvisioning"/> for deserialization. </summary>
        internal HomeNetworkPrivateKeysProvisioning()
        {
        }

        /// <summary>
        /// The provisioning state of the private keys for SUPI concealment.
        /// Serialized Name: HomeNetworkPrivateKeysProvisioning.state
        /// </summary>
        [WirePath("state")]
        public HomeNetworkPrivateKeysProvisioningState State { get; }
    }
}
