// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// The SIMs to upload. The SIM credentials must be encrypted.
    /// Serialized Name: EncryptedSimUploadList
    /// </summary>
    public partial class EncryptedSimUploadList
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EncryptedSimUploadList"/>. </summary>
        /// <param name="version">
        /// The upload file format version.
        /// Serialized Name: EncryptedSimUploadList.version
        /// </param>
        /// <param name="azureKeyIdentifier">
        /// An identifier for the Azure SIM onboarding public key used for encrypted upload.
        /// Serialized Name: EncryptedSimUploadList.azureKeyIdentifier
        /// </param>
        /// <param name="vendorKeyFingerprint">
        /// The fingerprint of the SIM vendor public key. The private counterpart is used for signing the encrypted transport key.
        /// Serialized Name: EncryptedSimUploadList.vendorKeyFingerprint
        /// </param>
        /// <param name="encryptedTransportKey">
        /// The transport key used for encrypting SIM credentials, encrypted using the SIM onboarding public key.
        /// Serialized Name: EncryptedSimUploadList.encryptedTransportKey
        /// </param>
        /// <param name="signedTransportKey">
        /// The encrypted transport key, signed using the SIM vendor private key.
        /// Serialized Name: EncryptedSimUploadList.signedTransportKey
        /// </param>
        /// <param name="sims">
        /// A list of SIMs to upload, with encrypted properties.
        /// Serialized Name: EncryptedSimUploadList.sims
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="vendorKeyFingerprint"/>, <paramref name="encryptedTransportKey"/>, <paramref name="signedTransportKey"/> or <paramref name="sims"/> is null. </exception>
        public EncryptedSimUploadList(int version, int azureKeyIdentifier, string vendorKeyFingerprint, string encryptedTransportKey, string signedTransportKey, IEnumerable<SimNameAndEncryptedProperties> sims)
        {
            Argument.AssertNotNull(vendorKeyFingerprint, nameof(vendorKeyFingerprint));
            Argument.AssertNotNull(encryptedTransportKey, nameof(encryptedTransportKey));
            Argument.AssertNotNull(signedTransportKey, nameof(signedTransportKey));
            Argument.AssertNotNull(sims, nameof(sims));

            Version = version;
            AzureKeyIdentifier = azureKeyIdentifier;
            VendorKeyFingerprint = vendorKeyFingerprint;
            EncryptedTransportKey = encryptedTransportKey;
            SignedTransportKey = signedTransportKey;
            Sims = sims.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="EncryptedSimUploadList"/>. </summary>
        /// <param name="version">
        /// The upload file format version.
        /// Serialized Name: EncryptedSimUploadList.version
        /// </param>
        /// <param name="azureKeyIdentifier">
        /// An identifier for the Azure SIM onboarding public key used for encrypted upload.
        /// Serialized Name: EncryptedSimUploadList.azureKeyIdentifier
        /// </param>
        /// <param name="vendorKeyFingerprint">
        /// The fingerprint of the SIM vendor public key. The private counterpart is used for signing the encrypted transport key.
        /// Serialized Name: EncryptedSimUploadList.vendorKeyFingerprint
        /// </param>
        /// <param name="encryptedTransportKey">
        /// The transport key used for encrypting SIM credentials, encrypted using the SIM onboarding public key.
        /// Serialized Name: EncryptedSimUploadList.encryptedTransportKey
        /// </param>
        /// <param name="signedTransportKey">
        /// The encrypted transport key, signed using the SIM vendor private key.
        /// Serialized Name: EncryptedSimUploadList.signedTransportKey
        /// </param>
        /// <param name="sims">
        /// A list of SIMs to upload, with encrypted properties.
        /// Serialized Name: EncryptedSimUploadList.sims
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EncryptedSimUploadList(int version, int azureKeyIdentifier, string vendorKeyFingerprint, string encryptedTransportKey, string signedTransportKey, IList<SimNameAndEncryptedProperties> sims, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Version = version;
            AzureKeyIdentifier = azureKeyIdentifier;
            VendorKeyFingerprint = vendorKeyFingerprint;
            EncryptedTransportKey = encryptedTransportKey;
            SignedTransportKey = signedTransportKey;
            Sims = sims;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="EncryptedSimUploadList"/> for deserialization. </summary>
        internal EncryptedSimUploadList()
        {
        }

        /// <summary>
        /// The upload file format version.
        /// Serialized Name: EncryptedSimUploadList.version
        /// </summary>
        [WirePath("version")]
        public int Version { get; }
        /// <summary>
        /// An identifier for the Azure SIM onboarding public key used for encrypted upload.
        /// Serialized Name: EncryptedSimUploadList.azureKeyIdentifier
        /// </summary>
        [WirePath("azureKeyIdentifier")]
        public int AzureKeyIdentifier { get; }
        /// <summary>
        /// The fingerprint of the SIM vendor public key. The private counterpart is used for signing the encrypted transport key.
        /// Serialized Name: EncryptedSimUploadList.vendorKeyFingerprint
        /// </summary>
        [WirePath("vendorKeyFingerprint")]
        public string VendorKeyFingerprint { get; }
        /// <summary>
        /// The transport key used for encrypting SIM credentials, encrypted using the SIM onboarding public key.
        /// Serialized Name: EncryptedSimUploadList.encryptedTransportKey
        /// </summary>
        [WirePath("encryptedTransportKey")]
        public string EncryptedTransportKey { get; }
        /// <summary>
        /// The encrypted transport key, signed using the SIM vendor private key.
        /// Serialized Name: EncryptedSimUploadList.signedTransportKey
        /// </summary>
        [WirePath("signedTransportKey")]
        public string SignedTransportKey { get; }
        /// <summary>
        /// A list of SIMs to upload, with encrypted properties.
        /// Serialized Name: EncryptedSimUploadList.sims
        /// </summary>
        [WirePath("sims")]
        public IList<SimNameAndEncryptedProperties> Sims { get; }
    }
}
