// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// DNN and UE IP address
    /// Serialized Name: DnnIpPair
    /// </summary>
    public partial class DnnIPPair
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DnnIPPair"/>. </summary>
        public DnnIPPair()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DnnIPPair"/>. </summary>
        /// <param name="dnn">
        /// Data network name
        /// Serialized Name: DnnIpPair.dnn
        /// </param>
        /// <param name="ipV4Addr">
        /// IPv4 address.
        /// Serialized Name: DnnIpPair.ueIpAddress.ipV4Addr
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DnnIPPair(string dnn, string ipV4Addr, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Dnn = dnn;
            IPV4Addr = ipV4Addr;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// Data network name
        /// Serialized Name: DnnIpPair.dnn
        /// </summary>
        [WirePath("dnn")]
        public string Dnn { get; set; }
        /// <summary>
        /// IPv4 address.
        /// Serialized Name: DnnIpPair.ueIpAddress.ipV4Addr
        /// </summary>
        [WirePath("ueIpAddress.ipV4Addr")]
        public string IPV4Addr { get; set; }
    }
}
