// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// Configuration for uploading packet core diagnostics.
    /// Serialized Name: DiagnosticsUploadConfiguration
    /// </summary>
    internal partial class DiagnosticsUploadConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DiagnosticsUploadConfiguration"/>. </summary>
        /// <param name="storageAccountContainerUri">
        /// The Storage Account Container URL to upload diagnostics to.
        /// Serialized Name: DiagnosticsUploadConfiguration.storageAccountContainerUrl
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="storageAccountContainerUri"/> is null. </exception>
        public DiagnosticsUploadConfiguration(Uri storageAccountContainerUri)
        {
            Argument.AssertNotNull(storageAccountContainerUri, nameof(storageAccountContainerUri));

            StorageAccountContainerUri = storageAccountContainerUri;
        }

        /// <summary> Initializes a new instance of <see cref="DiagnosticsUploadConfiguration"/>. </summary>
        /// <param name="storageAccountContainerUri">
        /// The Storage Account Container URL to upload diagnostics to.
        /// Serialized Name: DiagnosticsUploadConfiguration.storageAccountContainerUrl
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DiagnosticsUploadConfiguration(Uri storageAccountContainerUri, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StorageAccountContainerUri = storageAccountContainerUri;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DiagnosticsUploadConfiguration"/> for deserialization. </summary>
        internal DiagnosticsUploadConfiguration()
        {
        }

        /// <summary>
        /// The Storage Account Container URL to upload diagnostics to.
        /// Serialized Name: DiagnosticsUploadConfiguration.storageAccountContainerUrl
        /// </summary>
        [WirePath("storageAccountContainerUrl")]
        public Uri StorageAccountContainerUri { get; set; }
    }
}
