// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// Response for diagnostics package API service call.
    /// Serialized Name: DiagnosticsPackageListResult
    /// </summary>
    internal partial class DiagnosticsPackageListResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DiagnosticsPackageListResult"/>. </summary>
        internal DiagnosticsPackageListResult()
        {
            Value = new ChangeTrackingList<MobileNetworkDiagnosticsPackageData>();
        }

        /// <summary> Initializes a new instance of <see cref="DiagnosticsPackageListResult"/>. </summary>
        /// <param name="value">
        /// A list of diagnostics packages under a packet core control plane.
        /// Serialized Name: DiagnosticsPackageListResult.value
        /// </param>
        /// <param name="nextLink">
        /// The URL to get the next set of results.
        /// Serialized Name: DiagnosticsPackageListResult.nextLink
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DiagnosticsPackageListResult(IReadOnlyList<MobileNetworkDiagnosticsPackageData> value, string nextLink, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Value = value;
            NextLink = nextLink;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// A list of diagnostics packages under a packet core control plane.
        /// Serialized Name: DiagnosticsPackageListResult.value
        /// </summary>
        public IReadOnlyList<MobileNetworkDiagnosticsPackageData> Value { get; }
        /// <summary>
        /// The URL to get the next set of results.
        /// Serialized Name: DiagnosticsPackageListResult.nextLink
        /// </summary>
        public string NextLink { get; }
    }
}
