// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    public partial class DataNetworkConfiguration : IUtf8JsonSerializable, IJsonModel<DataNetworkConfiguration>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DataNetworkConfiguration>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DataNetworkConfiguration>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataNetworkConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DataNetworkConfiguration)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("dataNetwork"u8);
            JsonSerializer.Serialize(writer, DataNetwork);
            writer.WritePropertyName("sessionAmbr"u8);
            writer.WriteObjectValue(SessionAmbr, options);
            if (Optional.IsDefined(FiveQi))
            {
                writer.WritePropertyName("5qi"u8);
                writer.WriteNumberValue(FiveQi.Value);
            }
            if (Optional.IsDefined(AllocationAndRetentionPriorityLevel))
            {
                writer.WritePropertyName("allocationAndRetentionPriorityLevel"u8);
                writer.WriteNumberValue(AllocationAndRetentionPriorityLevel.Value);
            }
            if (Optional.IsDefined(PreemptionCapability))
            {
                writer.WritePropertyName("preemptionCapability"u8);
                writer.WriteStringValue(PreemptionCapability.Value.ToString());
            }
            if (Optional.IsDefined(PreemptionVulnerability))
            {
                writer.WritePropertyName("preemptionVulnerability"u8);
                writer.WriteStringValue(PreemptionVulnerability.Value.ToString());
            }
            if (Optional.IsDefined(DefaultSessionType))
            {
                writer.WritePropertyName("defaultSessionType"u8);
                writer.WriteStringValue(DefaultSessionType.Value.ToString());
            }
            if (Optional.IsCollectionDefined(AdditionalAllowedSessionTypes))
            {
                writer.WritePropertyName("additionalAllowedSessionTypes"u8);
                writer.WriteStartArray();
                foreach (var item in AdditionalAllowedSessionTypes)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            writer.WritePropertyName("allowedServices"u8);
            writer.WriteStartArray();
            foreach (var item in AllowedServices)
            {
                JsonSerializer.Serialize(writer, item);
            }
            writer.WriteEndArray();
            if (Optional.IsDefined(MaximumNumberOfBufferedPackets))
            {
                writer.WritePropertyName("maximumNumberOfBufferedPackets"u8);
                writer.WriteNumberValue(MaximumNumberOfBufferedPackets.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DataNetworkConfiguration IJsonModel<DataNetworkConfiguration>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataNetworkConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DataNetworkConfiguration)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDataNetworkConfiguration(document.RootElement, options);
        }

        internal static DataNetworkConfiguration DeserializeDataNetworkConfiguration(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            WritableSubResource dataNetwork = default;
            Ambr sessionAmbr = default;
            int? _5qi = default;
            int? allocationAndRetentionPriorityLevel = default;
            MobileNetworkPreemptionCapability? preemptionCapability = default;
            MobileNetworkPreemptionVulnerability? preemptionVulnerability = default;
            MobileNetworkPduSessionType? defaultSessionType = default;
            IList<MobileNetworkPduSessionType> additionalAllowedSessionTypes = default;
            IList<WritableSubResource> allowedServices = default;
            int? maximumNumberOfBufferedPackets = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("dataNetwork"u8))
                {
                    dataNetwork = JsonSerializer.Deserialize<WritableSubResource>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("sessionAmbr"u8))
                {
                    sessionAmbr = Ambr.DeserializeAmbr(property.Value, options);
                    continue;
                }
                if (property.NameEquals("5qi"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    _5qi = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("allocationAndRetentionPriorityLevel"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    allocationAndRetentionPriorityLevel = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("preemptionCapability"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    preemptionCapability = new MobileNetworkPreemptionCapability(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("preemptionVulnerability"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    preemptionVulnerability = new MobileNetworkPreemptionVulnerability(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("defaultSessionType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    defaultSessionType = new MobileNetworkPduSessionType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("additionalAllowedSessionTypes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<MobileNetworkPduSessionType> array = new List<MobileNetworkPduSessionType>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new MobileNetworkPduSessionType(item.GetString()));
                    }
                    additionalAllowedSessionTypes = array;
                    continue;
                }
                if (property.NameEquals("allowedServices"u8))
                {
                    List<WritableSubResource> array = new List<WritableSubResource>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(JsonSerializer.Deserialize<WritableSubResource>(item.GetRawText()));
                    }
                    allowedServices = array;
                    continue;
                }
                if (property.NameEquals("maximumNumberOfBufferedPackets"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maximumNumberOfBufferedPackets = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DataNetworkConfiguration(
                dataNetwork,
                sessionAmbr,
                _5qi,
                allocationAndRetentionPriorityLevel,
                preemptionCapability,
                preemptionVulnerability,
                defaultSessionType,
                additionalAllowedSessionTypes ?? new ChangeTrackingList<MobileNetworkPduSessionType>(),
                allowedServices,
                maximumNumberOfBufferedPackets,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("DataNetworkId", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  dataNetwork: ");
                builder.AppendLine("{");
                builder.Append("    id: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(DataNetwork))
                {
                    builder.Append("  dataNetwork: ");
                    BicepSerializationHelpers.AppendChildObject(builder, DataNetwork, options, 2, false, "  dataNetwork: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SessionAmbr), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  sessionAmbr: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SessionAmbr))
                {
                    builder.Append("  sessionAmbr: ");
                    BicepSerializationHelpers.AppendChildObject(builder, SessionAmbr, options, 2, false, "  sessionAmbr: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FiveQi), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  5qi: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(FiveQi))
                {
                    builder.Append("  5qi: ");
                    builder.AppendLine($"{FiveQi.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AllocationAndRetentionPriorityLevel), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  allocationAndRetentionPriorityLevel: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AllocationAndRetentionPriorityLevel))
                {
                    builder.Append("  allocationAndRetentionPriorityLevel: ");
                    builder.AppendLine($"{AllocationAndRetentionPriorityLevel.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PreemptionCapability), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  preemptionCapability: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PreemptionCapability))
                {
                    builder.Append("  preemptionCapability: ");
                    builder.AppendLine($"'{PreemptionCapability.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PreemptionVulnerability), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  preemptionVulnerability: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PreemptionVulnerability))
                {
                    builder.Append("  preemptionVulnerability: ");
                    builder.AppendLine($"'{PreemptionVulnerability.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DefaultSessionType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  defaultSessionType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DefaultSessionType))
                {
                    builder.Append("  defaultSessionType: ");
                    builder.AppendLine($"'{DefaultSessionType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AdditionalAllowedSessionTypes), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  additionalAllowedSessionTypes: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(AdditionalAllowedSessionTypes))
                {
                    if (AdditionalAllowedSessionTypes.Any())
                    {
                        builder.Append("  additionalAllowedSessionTypes: ");
                        builder.AppendLine("[");
                        foreach (var item in AdditionalAllowedSessionTypes)
                        {
                            builder.AppendLine($"    '{item.ToString()}'");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AllowedServices), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  allowedServices: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(AllowedServices))
                {
                    if (AllowedServices.Any())
                    {
                        builder.Append("  allowedServices: ");
                        builder.AppendLine("[");
                        foreach (var item in AllowedServices)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  allowedServices: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MaximumNumberOfBufferedPackets), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  maximumNumberOfBufferedPackets: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MaximumNumberOfBufferedPackets))
                {
                    builder.Append("  maximumNumberOfBufferedPackets: ");
                    builder.AppendLine($"{MaximumNumberOfBufferedPackets.Value}");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<DataNetworkConfiguration>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataNetworkConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(DataNetworkConfiguration)} does not support writing '{options.Format}' format.");
            }
        }

        DataNetworkConfiguration IPersistableModel<DataNetworkConfiguration>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataNetworkConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDataNetworkConfiguration(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DataNetworkConfiguration)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DataNetworkConfiguration>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
