// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// The current status of an async operation.
    /// Serialized Name: AsyncOperationStatus
    /// </summary>
    public partial class AsyncOperationStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AsyncOperationStatus"/>. </summary>
        /// <param name="status">
        /// The operation status.
        /// Serialized Name: AsyncOperationStatus.status
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="status"/> is null. </exception>
        internal AsyncOperationStatus(string status)
        {
            Argument.AssertNotNull(status, nameof(status));

            Status = status;
        }

        /// <summary> Initializes a new instance of <see cref="AsyncOperationStatus"/>. </summary>
        /// <param name="id">
        /// Fully qualified ID for the async operation.
        /// Serialized Name: AsyncOperationStatus.id
        /// </param>
        /// <param name="name">
        /// Name of the async operation.
        /// Serialized Name: AsyncOperationStatus.name
        /// </param>
        /// <param name="status">
        /// The operation status.
        /// Serialized Name: AsyncOperationStatus.status
        /// </param>
        /// <param name="resourceId">
        /// Fully qualified ID for the resource that this async operation status relates to.
        /// Serialized Name: AsyncOperationStatus.resourceId
        /// </param>
        /// <param name="startOn">
        /// The start time of the operation.
        /// Serialized Name: AsyncOperationStatus.startTime
        /// </param>
        /// <param name="endOn">
        /// The end time of the operation.
        /// Serialized Name: AsyncOperationStatus.endTime
        /// </param>
        /// <param name="percentComplete">
        /// Percentage of the operation that is complete.
        /// Serialized Name: AsyncOperationStatus.percentComplete
        /// </param>
        /// <param name="properties">
        /// Properties returned by the resource provider on a successful operation
        /// Serialized Name: AsyncOperationStatus.properties
        /// </param>
        /// <param name="error">
        /// If present, details of the operation error.
        /// Serialized Name: AsyncOperationStatus.error
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AsyncOperationStatus(string id, string name, string status, string resourceId, DateTimeOffset? startOn, DateTimeOffset? endOn, double? percentComplete, BinaryData properties, ResponseError error, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Name = name;
            Status = status;
            ResourceId = resourceId;
            StartOn = startOn;
            EndOn = endOn;
            PercentComplete = percentComplete;
            Properties = properties;
            Error = error;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AsyncOperationStatus"/> for deserialization. </summary>
        internal AsyncOperationStatus()
        {
        }

        /// <summary>
        /// Fully qualified ID for the async operation.
        /// Serialized Name: AsyncOperationStatus.id
        /// </summary>
        [WirePath("id")]
        public string Id { get; }
        /// <summary>
        /// Name of the async operation.
        /// Serialized Name: AsyncOperationStatus.name
        /// </summary>
        [WirePath("name")]
        public string Name { get; }
        /// <summary>
        /// The operation status.
        /// Serialized Name: AsyncOperationStatus.status
        /// </summary>
        [WirePath("status")]
        public string Status { get; }
        /// <summary>
        /// Fully qualified ID for the resource that this async operation status relates to.
        /// Serialized Name: AsyncOperationStatus.resourceId
        /// </summary>
        [WirePath("resourceId")]
        public string ResourceId { get; }
        /// <summary>
        /// The start time of the operation.
        /// Serialized Name: AsyncOperationStatus.startTime
        /// </summary>
        [WirePath("startTime")]
        public DateTimeOffset? StartOn { get; }
        /// <summary>
        /// The end time of the operation.
        /// Serialized Name: AsyncOperationStatus.endTime
        /// </summary>
        [WirePath("endTime")]
        public DateTimeOffset? EndOn { get; }
        /// <summary>
        /// Percentage of the operation that is complete.
        /// Serialized Name: AsyncOperationStatus.percentComplete
        /// </summary>
        [WirePath("percentComplete")]
        public double? PercentComplete { get; }
        /// <summary>
        /// Properties returned by the resource provider on a successful operation
        /// Serialized Name: AsyncOperationStatus.properties
        /// <para>
        /// To assign an object to this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        [WirePath("properties")]
        public BinaryData Properties { get; }
        /// <summary>
        /// If present, details of the operation error.
        /// Serialized Name: AsyncOperationStatus.error
        /// </summary>
        [WirePath("error")]
        public ResponseError Error { get; }
    }
}
