// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.MobileNetwork.Models;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.MobileNetwork
{
    /// <summary>
    /// A class representing the MobileNetworkSim data model.
    /// SIM resource.
    /// Serialized Name: Sim
    /// </summary>
    public partial class MobileNetworkSimData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MobileNetworkSimData"/>. </summary>
        /// <param name="internationalMobileSubscriberIdentity">
        /// The international mobile subscriber identity (IMSI) for the SIM.
        /// Serialized Name: Sim.properties.internationalMobileSubscriberIdentity
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="internationalMobileSubscriberIdentity"/> is null. </exception>
        public MobileNetworkSimData(string internationalMobileSubscriberIdentity)
        {
            Argument.AssertNotNull(internationalMobileSubscriberIdentity, nameof(internationalMobileSubscriberIdentity));

            SiteProvisioningState = new ChangeTrackingDictionary<string, MobileNetworkSiteProvisioningState>();
            InternationalMobileSubscriberIdentity = internationalMobileSubscriberIdentity;
            StaticIPConfiguration = new ChangeTrackingList<SimStaticIPProperties>();
        }

        /// <summary> Initializes a new instance of <see cref="MobileNetworkSimData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState">
        /// The provisioning state of the SIM resource.
        /// Serialized Name: Sim.properties.provisioningState
        /// </param>
        /// <param name="simState">
        /// The state of the SIM resource.
        /// Serialized Name: Sim.properties.simState
        /// </param>
        /// <param name="siteProvisioningState">
        /// A dictionary of sites to the provisioning state of this SIM on that site.
        /// Serialized Name: Sim.properties.siteProvisioningState
        /// </param>
        /// <param name="internationalMobileSubscriberIdentity">
        /// The international mobile subscriber identity (IMSI) for the SIM.
        /// Serialized Name: Sim.properties.internationalMobileSubscriberIdentity
        /// </param>
        /// <param name="integratedCircuitCardIdentifier">
        /// The integrated circuit card ID (ICCID) for the SIM.
        /// Serialized Name: Sim.properties.integratedCircuitCardIdentifier
        /// </param>
        /// <param name="deviceType">
        /// An optional free-form text field that can be used to record the device type this SIM is associated with, for example 'Video camera'. The Azure portal allows SIMs to be grouped and filtered based on this value.
        /// Serialized Name: Sim.properties.deviceType
        /// </param>
        /// <param name="simPolicy">
        /// The SIM policy used by this SIM. The SIM policy must be in the same location as the SIM.
        /// Serialized Name: Sim.properties.simPolicy
        /// </param>
        /// <param name="staticIPConfiguration">
        /// A list of static IP addresses assigned to this SIM. Each address is assigned at a defined network scope, made up of {attached data network, slice}.
        /// Serialized Name: Sim.properties.staticIpConfiguration
        /// </param>
        /// <param name="vendorName">
        /// The name of the SIM vendor who provided this SIM, if any.
        /// Serialized Name: Sim.properties.vendorName
        /// </param>
        /// <param name="vendorKeyFingerprint">
        /// The public key fingerprint of the SIM vendor who provided this SIM, if any.
        /// Serialized Name: Sim.properties.vendorKeyFingerprint
        /// </param>
        /// <param name="authenticationKey">
        /// The Ki value for the SIM.
        /// Serialized Name: Sim.properties.authenticationKey
        /// </param>
        /// <param name="operatorKeyCode">
        /// The Opc value for the SIM.
        /// Serialized Name: Sim.properties.operatorKeyCode
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MobileNetworkSimData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, MobileNetworkProvisioningState? provisioningState, MobileNetworkSimState? simState, IReadOnlyDictionary<string, MobileNetworkSiteProvisioningState> siteProvisioningState, string internationalMobileSubscriberIdentity, string integratedCircuitCardIdentifier, string deviceType, WritableSubResource simPolicy, IList<SimStaticIPProperties> staticIPConfiguration, string vendorName, string vendorKeyFingerprint, string authenticationKey, string operatorKeyCode, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ProvisioningState = provisioningState;
            SimState = simState;
            SiteProvisioningState = siteProvisioningState;
            InternationalMobileSubscriberIdentity = internationalMobileSubscriberIdentity;
            IntegratedCircuitCardIdentifier = integratedCircuitCardIdentifier;
            DeviceType = deviceType;
            SimPolicy = simPolicy;
            StaticIPConfiguration = staticIPConfiguration;
            VendorName = vendorName;
            VendorKeyFingerprint = vendorKeyFingerprint;
            AuthenticationKey = authenticationKey;
            OperatorKeyCode = operatorKeyCode;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MobileNetworkSimData"/> for deserialization. </summary>
        internal MobileNetworkSimData()
        {
        }

        /// <summary>
        /// The provisioning state of the SIM resource.
        /// Serialized Name: Sim.properties.provisioningState
        /// </summary>
        [WirePath("properties.provisioningState")]
        public MobileNetworkProvisioningState? ProvisioningState { get; }
        /// <summary>
        /// The state of the SIM resource.
        /// Serialized Name: Sim.properties.simState
        /// </summary>
        [WirePath("properties.simState")]
        public MobileNetworkSimState? SimState { get; }
        /// <summary>
        /// A dictionary of sites to the provisioning state of this SIM on that site.
        /// Serialized Name: Sim.properties.siteProvisioningState
        /// </summary>
        [WirePath("properties.siteProvisioningState")]
        public IReadOnlyDictionary<string, MobileNetworkSiteProvisioningState> SiteProvisioningState { get; }
        /// <summary>
        /// The international mobile subscriber identity (IMSI) for the SIM.
        /// Serialized Name: Sim.properties.internationalMobileSubscriberIdentity
        /// </summary>
        [WirePath("properties.internationalMobileSubscriberIdentity")]
        public string InternationalMobileSubscriberIdentity { get; set; }
        /// <summary>
        /// The integrated circuit card ID (ICCID) for the SIM.
        /// Serialized Name: Sim.properties.integratedCircuitCardIdentifier
        /// </summary>
        [WirePath("properties.integratedCircuitCardIdentifier")]
        public string IntegratedCircuitCardIdentifier { get; set; }
        /// <summary>
        /// An optional free-form text field that can be used to record the device type this SIM is associated with, for example 'Video camera'. The Azure portal allows SIMs to be grouped and filtered based on this value.
        /// Serialized Name: Sim.properties.deviceType
        /// </summary>
        [WirePath("properties.deviceType")]
        public string DeviceType { get; set; }
        /// <summary>
        /// The SIM policy used by this SIM. The SIM policy must be in the same location as the SIM.
        /// Serialized Name: Sim.properties.simPolicy
        /// </summary>
        internal WritableSubResource SimPolicy { get; set; }
        /// <summary> Gets or sets Id. </summary>
        [WirePath("properties.simPolicy.id")]
        public ResourceIdentifier SimPolicyId
        {
            get => SimPolicy is null ? default : SimPolicy.Id;
            set
            {
                if (SimPolicy is null)
                    SimPolicy = new WritableSubResource();
                SimPolicy.Id = value;
            }
        }

        /// <summary>
        /// A list of static IP addresses assigned to this SIM. Each address is assigned at a defined network scope, made up of {attached data network, slice}.
        /// Serialized Name: Sim.properties.staticIpConfiguration
        /// </summary>
        [WirePath("properties.staticIpConfiguration")]
        public IList<SimStaticIPProperties> StaticIPConfiguration { get; }
        /// <summary>
        /// The name of the SIM vendor who provided this SIM, if any.
        /// Serialized Name: Sim.properties.vendorName
        /// </summary>
        [WirePath("properties.vendorName")]
        public string VendorName { get; }
        /// <summary>
        /// The public key fingerprint of the SIM vendor who provided this SIM, if any.
        /// Serialized Name: Sim.properties.vendorKeyFingerprint
        /// </summary>
        [WirePath("properties.vendorKeyFingerprint")]
        public string VendorKeyFingerprint { get; }
        /// <summary>
        /// The Ki value for the SIM.
        /// Serialized Name: Sim.properties.authenticationKey
        /// </summary>
        [WirePath("properties.authenticationKey")]
        public string AuthenticationKey { get; set; }
        /// <summary>
        /// The Opc value for the SIM.
        /// Serialized Name: Sim.properties.operatorKeyCode
        /// </summary>
        [WirePath("properties.operatorKeyCode")]
        public string OperatorKeyCode { get; set; }
    }
}
