// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.MobileNetwork
{
    /// <summary>
    /// A Class representing a MobileNetworkRoutingInfo along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="MobileNetworkRoutingInfoResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetMobileNetworkRoutingInfoResource method.
    /// Otherwise you can get one from its parent resource <see cref="PacketCoreControlPlaneResource"/> using the GetMobileNetworkRoutingInfo method.
    /// </summary>
    public partial class MobileNetworkRoutingInfoResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="MobileNetworkRoutingInfoResource"/> instance. </summary>
        /// <param name="subscriptionId"> The subscriptionId. </param>
        /// <param name="resourceGroupName"> The resourceGroupName. </param>
        /// <param name="packetCoreControlPlaneName"> The packetCoreControlPlaneName. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string subscriptionId, string resourceGroupName, string packetCoreControlPlaneName)
        {
            var resourceId = $"/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/routingInfo/default";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _mobileNetworkRoutingInfoRoutingInfoClientDiagnostics;
        private readonly RoutingInfoRestOperations _mobileNetworkRoutingInfoRoutingInfoRestClient;
        private readonly MobileNetworkRoutingInfoData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.MobileNetwork/packetCoreControlPlanes/routingInfo";

        /// <summary> Initializes a new instance of the <see cref="MobileNetworkRoutingInfoResource"/> class for mocking. </summary>
        protected MobileNetworkRoutingInfoResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MobileNetworkRoutingInfoResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal MobileNetworkRoutingInfoResource(ArmClient client, MobileNetworkRoutingInfoData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="MobileNetworkRoutingInfoResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MobileNetworkRoutingInfoResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _mobileNetworkRoutingInfoRoutingInfoClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.MobileNetwork", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string mobileNetworkRoutingInfoRoutingInfoApiVersion);
            _mobileNetworkRoutingInfoRoutingInfoRestClient = new RoutingInfoRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, mobileNetworkRoutingInfoRoutingInfoApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual MobileNetworkRoutingInfoData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Get the routing information for the packet core.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/routingInfo/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RoutingInfo_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MobileNetworkRoutingInfoResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<MobileNetworkRoutingInfoResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _mobileNetworkRoutingInfoRoutingInfoClientDiagnostics.CreateScope("MobileNetworkRoutingInfoResource.Get");
            scope.Start();
            try
            {
                var response = await _mobileNetworkRoutingInfoRoutingInfoRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new MobileNetworkRoutingInfoResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the routing information for the packet core.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/routingInfo/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RoutingInfo_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MobileNetworkRoutingInfoResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<MobileNetworkRoutingInfoResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _mobileNetworkRoutingInfoRoutingInfoClientDiagnostics.CreateScope("MobileNetworkRoutingInfoResource.Get");
            scope.Start();
            try
            {
                var response = _mobileNetworkRoutingInfoRoutingInfoRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new MobileNetworkRoutingInfoResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
