// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.MobileNetwork.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.MobileNetwork
{
    public partial class MobileNetworkRoutingInfoData : IUtf8JsonSerializable, IJsonModel<MobileNetworkRoutingInfoData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MobileNetworkRoutingInfoData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MobileNetworkRoutingInfoData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MobileNetworkRoutingInfoData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MobileNetworkRoutingInfoData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsCollectionDefined(ControlPlaneAccessRoutes))
            {
                writer.WritePropertyName("controlPlaneAccessRoutes"u8);
                writer.WriteStartArray();
                foreach (var item in ControlPlaneAccessRoutes)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(UserPlaneAccessRoutes))
            {
                writer.WritePropertyName("userPlaneAccessRoutes"u8);
                writer.WriteStartArray();
                foreach (var item in UserPlaneAccessRoutes)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(UserPlaneDataRoutes))
            {
                writer.WritePropertyName("userPlaneDataRoutes"u8);
                writer.WriteStartArray();
                foreach (var item in UserPlaneDataRoutes)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
        }

        MobileNetworkRoutingInfoData IJsonModel<MobileNetworkRoutingInfoData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MobileNetworkRoutingInfoData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MobileNetworkRoutingInfoData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMobileNetworkRoutingInfoData(document.RootElement, options);
        }

        internal static MobileNetworkRoutingInfoData DeserializeMobileNetworkRoutingInfoData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            IList<MobileNetworkIPv4Route> controlPlaneAccessRoutes = default;
            IList<MobileNetworkIPv4Route> userPlaneAccessRoutes = default;
            IList<UserPlaneDataRoutesItem> userPlaneDataRoutes = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("controlPlaneAccessRoutes"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<MobileNetworkIPv4Route> array = new List<MobileNetworkIPv4Route>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(MobileNetworkIPv4Route.DeserializeMobileNetworkIPv4Route(item, options));
                            }
                            controlPlaneAccessRoutes = array;
                            continue;
                        }
                        if (property0.NameEquals("userPlaneAccessRoutes"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<MobileNetworkIPv4Route> array = new List<MobileNetworkIPv4Route>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(MobileNetworkIPv4Route.DeserializeMobileNetworkIPv4Route(item, options));
                            }
                            userPlaneAccessRoutes = array;
                            continue;
                        }
                        if (property0.NameEquals("userPlaneDataRoutes"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<UserPlaneDataRoutesItem> array = new List<UserPlaneDataRoutesItem>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(UserPlaneDataRoutesItem.DeserializeUserPlaneDataRoutesItem(item, options));
                            }
                            userPlaneDataRoutes = array;
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MobileNetworkRoutingInfoData(
                id,
                name,
                type,
                systemData,
                controlPlaneAccessRoutes ?? new ChangeTrackingList<MobileNetworkIPv4Route>(),
                userPlaneAccessRoutes ?? new ChangeTrackingList<MobileNetworkIPv4Route>(),
                userPlaneDataRoutes ?? new ChangeTrackingList<UserPlaneDataRoutesItem>(),
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ControlPlaneAccessRoutes), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    controlPlaneAccessRoutes: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ControlPlaneAccessRoutes))
                {
                    if (ControlPlaneAccessRoutes.Any())
                    {
                        builder.Append("    controlPlaneAccessRoutes: ");
                        builder.AppendLine("[");
                        foreach (var item in ControlPlaneAccessRoutes)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    controlPlaneAccessRoutes: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(UserPlaneAccessRoutes), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    userPlaneAccessRoutes: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(UserPlaneAccessRoutes))
                {
                    if (UserPlaneAccessRoutes.Any())
                    {
                        builder.Append("    userPlaneAccessRoutes: ");
                        builder.AppendLine("[");
                        foreach (var item in UserPlaneAccessRoutes)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    userPlaneAccessRoutes: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(UserPlaneDataRoutes), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    userPlaneDataRoutes: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(UserPlaneDataRoutes))
                {
                    if (UserPlaneDataRoutes.Any())
                    {
                        builder.Append("    userPlaneDataRoutes: ");
                        builder.AppendLine("[");
                        foreach (var item in UserPlaneDataRoutes)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    userPlaneDataRoutes: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<MobileNetworkRoutingInfoData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MobileNetworkRoutingInfoData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(MobileNetworkRoutingInfoData)} does not support writing '{options.Format}' format.");
            }
        }

        MobileNetworkRoutingInfoData IPersistableModel<MobileNetworkRoutingInfoData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MobileNetworkRoutingInfoData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMobileNetworkRoutingInfoData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MobileNetworkRoutingInfoData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MobileNetworkRoutingInfoData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
