// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.MobileNetwork.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.MobileNetwork
{
    /// <summary>
    /// A class representing the MobileNetworkPacketCapture data model.
    /// Packet capture session resource.
    /// Serialized Name: PacketCapture
    /// </summary>
    public partial class MobileNetworkPacketCaptureData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MobileNetworkPacketCaptureData"/>. </summary>
        public MobileNetworkPacketCaptureData()
        {
            NetworkInterfaces = new ChangeTrackingList<string>();
            OutputFiles = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="MobileNetworkPacketCaptureData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState">
        /// The provisioning state of the packet capture session resource.
        /// Serialized Name: PacketCapture.properties.provisioningState
        /// </param>
        /// <param name="status">
        /// The status of the packet capture session.
        /// Serialized Name: PacketCapture.properties.status
        /// </param>
        /// <param name="reason">
        /// The reason the current packet capture session state.
        /// Serialized Name: PacketCapture.properties.reason
        /// </param>
        /// <param name="captureStartOn">
        /// The start time of the packet capture session.
        /// Serialized Name: PacketCapture.properties.captureStartTime
        /// </param>
        /// <param name="networkInterfaces">
        /// List of network interfaces to capture on.
        /// Serialized Name: PacketCapture.properties.networkInterfaces
        /// </param>
        /// <param name="bytesToCapturePerPacket">
        /// Number of bytes captured per packet, the remaining bytes are truncated. The default "0" means the entire packet is captured.
        /// Serialized Name: PacketCapture.properties.bytesToCapturePerPacket
        /// </param>
        /// <param name="totalBytesPerSession">
        /// Maximum size of the capture output.
        /// Serialized Name: PacketCapture.properties.totalBytesPerSession
        /// </param>
        /// <param name="timeLimitInSeconds">
        /// Maximum duration of the capture session in seconds.
        /// Serialized Name: PacketCapture.properties.timeLimitInSeconds
        /// </param>
        /// <param name="outputFiles">
        /// The list of output files of a packet capture session.
        /// Serialized Name: PacketCapture.properties.outputFiles
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MobileNetworkPacketCaptureData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, MobileNetworkProvisioningState? provisioningState, MobileNetworkPacketCaptureStatus? status, string reason, DateTimeOffset? captureStartOn, IList<string> networkInterfaces, long? bytesToCapturePerPacket, long? totalBytesPerSession, int? timeLimitInSeconds, IReadOnlyList<string> outputFiles, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ProvisioningState = provisioningState;
            Status = status;
            Reason = reason;
            CaptureStartOn = captureStartOn;
            NetworkInterfaces = networkInterfaces;
            BytesToCapturePerPacket = bytesToCapturePerPacket;
            TotalBytesPerSession = totalBytesPerSession;
            TimeLimitInSeconds = timeLimitInSeconds;
            OutputFiles = outputFiles;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The provisioning state of the packet capture session resource.
        /// Serialized Name: PacketCapture.properties.provisioningState
        /// </summary>
        [WirePath("properties.provisioningState")]
        public MobileNetworkProvisioningState? ProvisioningState { get; }
        /// <summary>
        /// The status of the packet capture session.
        /// Serialized Name: PacketCapture.properties.status
        /// </summary>
        [WirePath("properties.status")]
        public MobileNetworkPacketCaptureStatus? Status { get; }
        /// <summary>
        /// The reason the current packet capture session state.
        /// Serialized Name: PacketCapture.properties.reason
        /// </summary>
        [WirePath("properties.reason")]
        public string Reason { get; }
        /// <summary>
        /// The start time of the packet capture session.
        /// Serialized Name: PacketCapture.properties.captureStartTime
        /// </summary>
        [WirePath("properties.captureStartTime")]
        public DateTimeOffset? CaptureStartOn { get; }
        /// <summary>
        /// List of network interfaces to capture on.
        /// Serialized Name: PacketCapture.properties.networkInterfaces
        /// </summary>
        [WirePath("properties.networkInterfaces")]
        public IList<string> NetworkInterfaces { get; }
        /// <summary>
        /// Number of bytes captured per packet, the remaining bytes are truncated. The default "0" means the entire packet is captured.
        /// Serialized Name: PacketCapture.properties.bytesToCapturePerPacket
        /// </summary>
        [WirePath("properties.bytesToCapturePerPacket")]
        public long? BytesToCapturePerPacket { get; set; }
        /// <summary>
        /// Maximum size of the capture output.
        /// Serialized Name: PacketCapture.properties.totalBytesPerSession
        /// </summary>
        [WirePath("properties.totalBytesPerSession")]
        public long? TotalBytesPerSession { get; set; }
        /// <summary>
        /// Maximum duration of the capture session in seconds.
        /// Serialized Name: PacketCapture.properties.timeLimitInSeconds
        /// </summary>
        [WirePath("properties.timeLimitInSeconds")]
        public int? TimeLimitInSeconds { get; set; }
        /// <summary>
        /// The list of output files of a packet capture session.
        /// Serialized Name: PacketCapture.properties.outputFiles
        /// </summary>
        [WirePath("properties.outputFiles")]
        public IReadOnlyList<string> OutputFiles { get; }
    }
}
