// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.MobileNetwork
{
    /// <summary>
    /// A class representing a collection of <see cref="MobileNetworkPacketCaptureResource"/> and their operations.
    /// Each <see cref="MobileNetworkPacketCaptureResource"/> in the collection will belong to the same instance of <see cref="PacketCoreControlPlaneResource"/>.
    /// To get a <see cref="MobileNetworkPacketCaptureCollection"/> instance call the GetMobileNetworkPacketCaptures method from an instance of <see cref="PacketCoreControlPlaneResource"/>.
    /// </summary>
    public partial class MobileNetworkPacketCaptureCollection : ArmCollection, IEnumerable<MobileNetworkPacketCaptureResource>, IAsyncEnumerable<MobileNetworkPacketCaptureResource>
    {
        private readonly ClientDiagnostics _mobileNetworkPacketCapturePacketCapturesClientDiagnostics;
        private readonly PacketCapturesRestOperations _mobileNetworkPacketCapturePacketCapturesRestClient;

        /// <summary> Initializes a new instance of the <see cref="MobileNetworkPacketCaptureCollection"/> class for mocking. </summary>
        protected MobileNetworkPacketCaptureCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MobileNetworkPacketCaptureCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal MobileNetworkPacketCaptureCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _mobileNetworkPacketCapturePacketCapturesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.MobileNetwork", MobileNetworkPacketCaptureResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(MobileNetworkPacketCaptureResource.ResourceType, out string mobileNetworkPacketCapturePacketCapturesApiVersion);
            _mobileNetworkPacketCapturePacketCapturesRestClient = new PacketCapturesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, mobileNetworkPacketCapturePacketCapturesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != PacketCoreControlPlaneResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, PacketCoreControlPlaneResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates a packet capture.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/packetCaptures/{packetCaptureName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PacketCaptures_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MobileNetworkPacketCaptureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="packetCaptureName"> The name of the packet capture session. </param>
        /// <param name="data"> Parameters supplied to the create or update packet capture operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="packetCaptureName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="packetCaptureName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<MobileNetworkPacketCaptureResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string packetCaptureName, MobileNetworkPacketCaptureData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(packetCaptureName, nameof(packetCaptureName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _mobileNetworkPacketCapturePacketCapturesClientDiagnostics.CreateScope("MobileNetworkPacketCaptureCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _mobileNetworkPacketCapturePacketCapturesRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, packetCaptureName, data, cancellationToken).ConfigureAwait(false);
                var operation = new MobileNetworkArmOperation<MobileNetworkPacketCaptureResource>(new MobileNetworkPacketCaptureOperationSource(Client), _mobileNetworkPacketCapturePacketCapturesClientDiagnostics, Pipeline, _mobileNetworkPacketCapturePacketCapturesRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, packetCaptureName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates a packet capture.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/packetCaptures/{packetCaptureName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PacketCaptures_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MobileNetworkPacketCaptureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="packetCaptureName"> The name of the packet capture session. </param>
        /// <param name="data"> Parameters supplied to the create or update packet capture operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="packetCaptureName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="packetCaptureName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<MobileNetworkPacketCaptureResource> CreateOrUpdate(WaitUntil waitUntil, string packetCaptureName, MobileNetworkPacketCaptureData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(packetCaptureName, nameof(packetCaptureName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _mobileNetworkPacketCapturePacketCapturesClientDiagnostics.CreateScope("MobileNetworkPacketCaptureCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _mobileNetworkPacketCapturePacketCapturesRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, packetCaptureName, data, cancellationToken);
                var operation = new MobileNetworkArmOperation<MobileNetworkPacketCaptureResource>(new MobileNetworkPacketCaptureOperationSource(Client), _mobileNetworkPacketCapturePacketCapturesClientDiagnostics, Pipeline, _mobileNetworkPacketCapturePacketCapturesRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, packetCaptureName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets information about the specified packet capture session.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/packetCaptures/{packetCaptureName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PacketCaptures_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MobileNetworkPacketCaptureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="packetCaptureName"> The name of the packet capture session. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="packetCaptureName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="packetCaptureName"/> is null. </exception>
        public virtual async Task<Response<MobileNetworkPacketCaptureResource>> GetAsync(string packetCaptureName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(packetCaptureName, nameof(packetCaptureName));

            using var scope = _mobileNetworkPacketCapturePacketCapturesClientDiagnostics.CreateScope("MobileNetworkPacketCaptureCollection.Get");
            scope.Start();
            try
            {
                var response = await _mobileNetworkPacketCapturePacketCapturesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, packetCaptureName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new MobileNetworkPacketCaptureResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets information about the specified packet capture session.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/packetCaptures/{packetCaptureName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PacketCaptures_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MobileNetworkPacketCaptureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="packetCaptureName"> The name of the packet capture session. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="packetCaptureName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="packetCaptureName"/> is null. </exception>
        public virtual Response<MobileNetworkPacketCaptureResource> Get(string packetCaptureName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(packetCaptureName, nameof(packetCaptureName));

            using var scope = _mobileNetworkPacketCapturePacketCapturesClientDiagnostics.CreateScope("MobileNetworkPacketCaptureCollection.Get");
            scope.Start();
            try
            {
                var response = _mobileNetworkPacketCapturePacketCapturesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, packetCaptureName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new MobileNetworkPacketCaptureResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists all the packet capture sessions under a packet core control plane.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/packetCaptures</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PacketCaptures_ListByPacketCoreControlPlane</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MobileNetworkPacketCaptureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="MobileNetworkPacketCaptureResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<MobileNetworkPacketCaptureResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _mobileNetworkPacketCapturePacketCapturesRestClient.CreateListByPacketCoreControlPlaneRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _mobileNetworkPacketCapturePacketCapturesRestClient.CreateListByPacketCoreControlPlaneNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new MobileNetworkPacketCaptureResource(Client, MobileNetworkPacketCaptureData.DeserializeMobileNetworkPacketCaptureData(e)), _mobileNetworkPacketCapturePacketCapturesClientDiagnostics, Pipeline, "MobileNetworkPacketCaptureCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists all the packet capture sessions under a packet core control plane.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/packetCaptures</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PacketCaptures_ListByPacketCoreControlPlane</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MobileNetworkPacketCaptureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="MobileNetworkPacketCaptureResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<MobileNetworkPacketCaptureResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _mobileNetworkPacketCapturePacketCapturesRestClient.CreateListByPacketCoreControlPlaneRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _mobileNetworkPacketCapturePacketCapturesRestClient.CreateListByPacketCoreControlPlaneNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new MobileNetworkPacketCaptureResource(Client, MobileNetworkPacketCaptureData.DeserializeMobileNetworkPacketCaptureData(e)), _mobileNetworkPacketCapturePacketCapturesClientDiagnostics, Pipeline, "MobileNetworkPacketCaptureCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/packetCaptures/{packetCaptureName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PacketCaptures_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MobileNetworkPacketCaptureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="packetCaptureName"> The name of the packet capture session. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="packetCaptureName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="packetCaptureName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string packetCaptureName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(packetCaptureName, nameof(packetCaptureName));

            using var scope = _mobileNetworkPacketCapturePacketCapturesClientDiagnostics.CreateScope("MobileNetworkPacketCaptureCollection.Exists");
            scope.Start();
            try
            {
                var response = await _mobileNetworkPacketCapturePacketCapturesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, packetCaptureName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/packetCaptures/{packetCaptureName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PacketCaptures_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MobileNetworkPacketCaptureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="packetCaptureName"> The name of the packet capture session. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="packetCaptureName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="packetCaptureName"/> is null. </exception>
        public virtual Response<bool> Exists(string packetCaptureName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(packetCaptureName, nameof(packetCaptureName));

            using var scope = _mobileNetworkPacketCapturePacketCapturesClientDiagnostics.CreateScope("MobileNetworkPacketCaptureCollection.Exists");
            scope.Start();
            try
            {
                var response = _mobileNetworkPacketCapturePacketCapturesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, packetCaptureName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/packetCaptures/{packetCaptureName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PacketCaptures_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MobileNetworkPacketCaptureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="packetCaptureName"> The name of the packet capture session. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="packetCaptureName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="packetCaptureName"/> is null. </exception>
        public virtual async Task<NullableResponse<MobileNetworkPacketCaptureResource>> GetIfExistsAsync(string packetCaptureName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(packetCaptureName, nameof(packetCaptureName));

            using var scope = _mobileNetworkPacketCapturePacketCapturesClientDiagnostics.CreateScope("MobileNetworkPacketCaptureCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _mobileNetworkPacketCapturePacketCapturesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, packetCaptureName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<MobileNetworkPacketCaptureResource>(response.GetRawResponse());
                return Response.FromValue(new MobileNetworkPacketCaptureResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/packetCaptures/{packetCaptureName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PacketCaptures_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MobileNetworkPacketCaptureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="packetCaptureName"> The name of the packet capture session. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="packetCaptureName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="packetCaptureName"/> is null. </exception>
        public virtual NullableResponse<MobileNetworkPacketCaptureResource> GetIfExists(string packetCaptureName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(packetCaptureName, nameof(packetCaptureName));

            using var scope = _mobileNetworkPacketCapturePacketCapturesClientDiagnostics.CreateScope("MobileNetworkPacketCaptureCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _mobileNetworkPacketCapturePacketCapturesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, packetCaptureName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<MobileNetworkPacketCaptureResource>(response.GetRawResponse());
                return Response.FromValue(new MobileNetworkPacketCaptureResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<MobileNetworkPacketCaptureResource> IEnumerable<MobileNetworkPacketCaptureResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<MobileNetworkPacketCaptureResource> IAsyncEnumerable<MobileNetworkPacketCaptureResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
