// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.MobileNetwork
{
    /// <summary>
    /// A class representing a collection of <see cref="MobileNetworkDiagnosticsPackageResource"/> and their operations.
    /// Each <see cref="MobileNetworkDiagnosticsPackageResource"/> in the collection will belong to the same instance of <see cref="PacketCoreControlPlaneResource"/>.
    /// To get a <see cref="MobileNetworkDiagnosticsPackageCollection"/> instance call the GetMobileNetworkDiagnosticsPackages method from an instance of <see cref="PacketCoreControlPlaneResource"/>.
    /// </summary>
    public partial class MobileNetworkDiagnosticsPackageCollection : ArmCollection, IEnumerable<MobileNetworkDiagnosticsPackageResource>, IAsyncEnumerable<MobileNetworkDiagnosticsPackageResource>
    {
        private readonly ClientDiagnostics _mobileNetworkDiagnosticsPackageDiagnosticsPackagesClientDiagnostics;
        private readonly DiagnosticsPackagesRestOperations _mobileNetworkDiagnosticsPackageDiagnosticsPackagesRestClient;

        /// <summary> Initializes a new instance of the <see cref="MobileNetworkDiagnosticsPackageCollection"/> class for mocking. </summary>
        protected MobileNetworkDiagnosticsPackageCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MobileNetworkDiagnosticsPackageCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal MobileNetworkDiagnosticsPackageCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _mobileNetworkDiagnosticsPackageDiagnosticsPackagesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.MobileNetwork", MobileNetworkDiagnosticsPackageResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(MobileNetworkDiagnosticsPackageResource.ResourceType, out string mobileNetworkDiagnosticsPackageDiagnosticsPackagesApiVersion);
            _mobileNetworkDiagnosticsPackageDiagnosticsPackagesRestClient = new DiagnosticsPackagesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, mobileNetworkDiagnosticsPackageDiagnosticsPackagesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != PacketCoreControlPlaneResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, PacketCoreControlPlaneResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates a diagnostics package.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/diagnosticsPackages/{diagnosticsPackageName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DiagnosticsPackages_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MobileNetworkDiagnosticsPackageResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="diagnosticsPackageName"> The name of the diagnostics package. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="diagnosticsPackageName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="diagnosticsPackageName"/> is null. </exception>
        public virtual async Task<ArmOperation<MobileNetworkDiagnosticsPackageResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string diagnosticsPackageName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(diagnosticsPackageName, nameof(diagnosticsPackageName));

            using var scope = _mobileNetworkDiagnosticsPackageDiagnosticsPackagesClientDiagnostics.CreateScope("MobileNetworkDiagnosticsPackageCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _mobileNetworkDiagnosticsPackageDiagnosticsPackagesRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, diagnosticsPackageName, cancellationToken).ConfigureAwait(false);
                var operation = new MobileNetworkArmOperation<MobileNetworkDiagnosticsPackageResource>(new MobileNetworkDiagnosticsPackageOperationSource(Client), _mobileNetworkDiagnosticsPackageDiagnosticsPackagesClientDiagnostics, Pipeline, _mobileNetworkDiagnosticsPackageDiagnosticsPackagesRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, diagnosticsPackageName).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates a diagnostics package.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/diagnosticsPackages/{diagnosticsPackageName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DiagnosticsPackages_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MobileNetworkDiagnosticsPackageResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="diagnosticsPackageName"> The name of the diagnostics package. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="diagnosticsPackageName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="diagnosticsPackageName"/> is null. </exception>
        public virtual ArmOperation<MobileNetworkDiagnosticsPackageResource> CreateOrUpdate(WaitUntil waitUntil, string diagnosticsPackageName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(diagnosticsPackageName, nameof(diagnosticsPackageName));

            using var scope = _mobileNetworkDiagnosticsPackageDiagnosticsPackagesClientDiagnostics.CreateScope("MobileNetworkDiagnosticsPackageCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _mobileNetworkDiagnosticsPackageDiagnosticsPackagesRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, diagnosticsPackageName, cancellationToken);
                var operation = new MobileNetworkArmOperation<MobileNetworkDiagnosticsPackageResource>(new MobileNetworkDiagnosticsPackageOperationSource(Client), _mobileNetworkDiagnosticsPackageDiagnosticsPackagesClientDiagnostics, Pipeline, _mobileNetworkDiagnosticsPackageDiagnosticsPackagesRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, diagnosticsPackageName).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets information about the specified diagnostics package.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/diagnosticsPackages/{diagnosticsPackageName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DiagnosticsPackages_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MobileNetworkDiagnosticsPackageResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="diagnosticsPackageName"> The name of the diagnostics package. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="diagnosticsPackageName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="diagnosticsPackageName"/> is null. </exception>
        public virtual async Task<Response<MobileNetworkDiagnosticsPackageResource>> GetAsync(string diagnosticsPackageName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(diagnosticsPackageName, nameof(diagnosticsPackageName));

            using var scope = _mobileNetworkDiagnosticsPackageDiagnosticsPackagesClientDiagnostics.CreateScope("MobileNetworkDiagnosticsPackageCollection.Get");
            scope.Start();
            try
            {
                var response = await _mobileNetworkDiagnosticsPackageDiagnosticsPackagesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, diagnosticsPackageName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new MobileNetworkDiagnosticsPackageResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets information about the specified diagnostics package.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/diagnosticsPackages/{diagnosticsPackageName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DiagnosticsPackages_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MobileNetworkDiagnosticsPackageResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="diagnosticsPackageName"> The name of the diagnostics package. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="diagnosticsPackageName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="diagnosticsPackageName"/> is null. </exception>
        public virtual Response<MobileNetworkDiagnosticsPackageResource> Get(string diagnosticsPackageName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(diagnosticsPackageName, nameof(diagnosticsPackageName));

            using var scope = _mobileNetworkDiagnosticsPackageDiagnosticsPackagesClientDiagnostics.CreateScope("MobileNetworkDiagnosticsPackageCollection.Get");
            scope.Start();
            try
            {
                var response = _mobileNetworkDiagnosticsPackageDiagnosticsPackagesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, diagnosticsPackageName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new MobileNetworkDiagnosticsPackageResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists all the diagnostics packages under a packet core control plane.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/diagnosticsPackages</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DiagnosticsPackages_ListByPacketCoreControlPlane</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MobileNetworkDiagnosticsPackageResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="MobileNetworkDiagnosticsPackageResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<MobileNetworkDiagnosticsPackageResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _mobileNetworkDiagnosticsPackageDiagnosticsPackagesRestClient.CreateListByPacketCoreControlPlaneRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _mobileNetworkDiagnosticsPackageDiagnosticsPackagesRestClient.CreateListByPacketCoreControlPlaneNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new MobileNetworkDiagnosticsPackageResource(Client, MobileNetworkDiagnosticsPackageData.DeserializeMobileNetworkDiagnosticsPackageData(e)), _mobileNetworkDiagnosticsPackageDiagnosticsPackagesClientDiagnostics, Pipeline, "MobileNetworkDiagnosticsPackageCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists all the diagnostics packages under a packet core control plane.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/diagnosticsPackages</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DiagnosticsPackages_ListByPacketCoreControlPlane</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MobileNetworkDiagnosticsPackageResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="MobileNetworkDiagnosticsPackageResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<MobileNetworkDiagnosticsPackageResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _mobileNetworkDiagnosticsPackageDiagnosticsPackagesRestClient.CreateListByPacketCoreControlPlaneRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _mobileNetworkDiagnosticsPackageDiagnosticsPackagesRestClient.CreateListByPacketCoreControlPlaneNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new MobileNetworkDiagnosticsPackageResource(Client, MobileNetworkDiagnosticsPackageData.DeserializeMobileNetworkDiagnosticsPackageData(e)), _mobileNetworkDiagnosticsPackageDiagnosticsPackagesClientDiagnostics, Pipeline, "MobileNetworkDiagnosticsPackageCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/diagnosticsPackages/{diagnosticsPackageName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DiagnosticsPackages_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MobileNetworkDiagnosticsPackageResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="diagnosticsPackageName"> The name of the diagnostics package. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="diagnosticsPackageName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="diagnosticsPackageName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string diagnosticsPackageName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(diagnosticsPackageName, nameof(diagnosticsPackageName));

            using var scope = _mobileNetworkDiagnosticsPackageDiagnosticsPackagesClientDiagnostics.CreateScope("MobileNetworkDiagnosticsPackageCollection.Exists");
            scope.Start();
            try
            {
                var response = await _mobileNetworkDiagnosticsPackageDiagnosticsPackagesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, diagnosticsPackageName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/diagnosticsPackages/{diagnosticsPackageName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DiagnosticsPackages_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MobileNetworkDiagnosticsPackageResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="diagnosticsPackageName"> The name of the diagnostics package. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="diagnosticsPackageName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="diagnosticsPackageName"/> is null. </exception>
        public virtual Response<bool> Exists(string diagnosticsPackageName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(diagnosticsPackageName, nameof(diagnosticsPackageName));

            using var scope = _mobileNetworkDiagnosticsPackageDiagnosticsPackagesClientDiagnostics.CreateScope("MobileNetworkDiagnosticsPackageCollection.Exists");
            scope.Start();
            try
            {
                var response = _mobileNetworkDiagnosticsPackageDiagnosticsPackagesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, diagnosticsPackageName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/diagnosticsPackages/{diagnosticsPackageName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DiagnosticsPackages_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MobileNetworkDiagnosticsPackageResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="diagnosticsPackageName"> The name of the diagnostics package. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="diagnosticsPackageName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="diagnosticsPackageName"/> is null. </exception>
        public virtual async Task<NullableResponse<MobileNetworkDiagnosticsPackageResource>> GetIfExistsAsync(string diagnosticsPackageName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(diagnosticsPackageName, nameof(diagnosticsPackageName));

            using var scope = _mobileNetworkDiagnosticsPackageDiagnosticsPackagesClientDiagnostics.CreateScope("MobileNetworkDiagnosticsPackageCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _mobileNetworkDiagnosticsPackageDiagnosticsPackagesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, diagnosticsPackageName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<MobileNetworkDiagnosticsPackageResource>(response.GetRawResponse());
                return Response.FromValue(new MobileNetworkDiagnosticsPackageResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/diagnosticsPackages/{diagnosticsPackageName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DiagnosticsPackages_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MobileNetworkDiagnosticsPackageResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="diagnosticsPackageName"> The name of the diagnostics package. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="diagnosticsPackageName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="diagnosticsPackageName"/> is null. </exception>
        public virtual NullableResponse<MobileNetworkDiagnosticsPackageResource> GetIfExists(string diagnosticsPackageName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(diagnosticsPackageName, nameof(diagnosticsPackageName));

            using var scope = _mobileNetworkDiagnosticsPackageDiagnosticsPackagesClientDiagnostics.CreateScope("MobileNetworkDiagnosticsPackageCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _mobileNetworkDiagnosticsPackageDiagnosticsPackagesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, diagnosticsPackageName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<MobileNetworkDiagnosticsPackageResource>(response.GetRawResponse());
                return Response.FromValue(new MobileNetworkDiagnosticsPackageResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<MobileNetworkDiagnosticsPackageResource> IEnumerable<MobileNetworkDiagnosticsPackageResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<MobileNetworkDiagnosticsPackageResource> IAsyncEnumerable<MobileNetworkDiagnosticsPackageResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
