// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.MobileNetwork.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.MobileNetwork
{
    /// <summary>
    /// A class representing the MobileAttachedDataNetwork data model.
    /// Attached data network resource. Must be created in the same location as its parent packet core data plane.
    /// Serialized Name: AttachedDataNetwork
    /// </summary>
    public partial class MobileAttachedDataNetworkData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MobileAttachedDataNetworkData"/>. </summary>
        /// <param name="location"> The location. </param>
        /// <param name="userPlaneDataInterface">
        /// The user plane interface on the data network. For 5G networks, this is the N6 interface. For 4G networks, this is the SGi interface.
        /// Serialized Name: AttachedDataNetwork.properties.userPlaneDataInterface
        /// </param>
        /// <param name="dnsAddresses">
        /// The DNS servers to signal to UEs to use for this attached data network. This configuration is mandatory - if you don't want DNS servers, you must provide an empty array.
        /// Serialized Name: AttachedDataNetwork.properties.dnsAddresses
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="userPlaneDataInterface"/> or <paramref name="dnsAddresses"/> is null. </exception>
        public MobileAttachedDataNetworkData(AzureLocation location, MobileNetworkInterfaceProperties userPlaneDataInterface, IEnumerable<string> dnsAddresses) : base(location)
        {
            Argument.AssertNotNull(userPlaneDataInterface, nameof(userPlaneDataInterface));
            Argument.AssertNotNull(dnsAddresses, nameof(dnsAddresses));

            UserPlaneDataInterface = userPlaneDataInterface;
            DnsAddresses = dnsAddresses.ToList();
            UserEquipmentAddressPoolPrefix = new ChangeTrackingList<string>();
            UserEquipmentStaticAddressPoolPrefix = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="MobileAttachedDataNetworkData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="provisioningState">
        /// The provisioning state of the attached data network resource.
        /// Serialized Name: AttachedDataNetwork.properties.provisioningState
        /// </param>
        /// <param name="userPlaneDataInterface">
        /// The user plane interface on the data network. For 5G networks, this is the N6 interface. For 4G networks, this is the SGi interface.
        /// Serialized Name: AttachedDataNetwork.properties.userPlaneDataInterface
        /// </param>
        /// <param name="dnsAddresses">
        /// The DNS servers to signal to UEs to use for this attached data network. This configuration is mandatory - if you don't want DNS servers, you must provide an empty array.
        /// Serialized Name: AttachedDataNetwork.properties.dnsAddresses
        /// </param>
        /// <param name="naptConfiguration">
        /// The network address and port translation (NAPT) configuration.
        /// If this is not specified, the attached data network will use a default NAPT configuration with NAPT enabled.
        /// Serialized Name: AttachedDataNetwork.properties.naptConfiguration
        /// </param>
        /// <param name="userEquipmentAddressPoolPrefix">
        /// The user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will dynamically assign IP addresses to UEs.
        /// The packet core instance assigns an IP address to a UE when the UE sets up a PDU session.
        ///  You must define at least one of userEquipmentAddressPoolPrefix and userEquipmentStaticAddressPoolPrefix. If you define both, they must be of the same size.
        /// Serialized Name: AttachedDataNetwork.properties.userEquipmentAddressPoolPrefix
        /// </param>
        /// <param name="userEquipmentStaticAddressPoolPrefix">
        /// The user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will assign static IP addresses to UEs.
        /// The packet core instance assigns an IP address to a UE when the UE sets up a PDU session. The static IP address for a specific UE is set in StaticIPConfiguration on the corresponding SIM resource.
        /// At least one of userEquipmentAddressPoolPrefix and userEquipmentStaticAddressPoolPrefix must be defined. If both are defined, they must be of the same size.
        /// Serialized Name: AttachedDataNetwork.properties.userEquipmentStaticAddressPoolPrefix
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MobileAttachedDataNetworkData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, MobileNetworkProvisioningState? provisioningState, MobileNetworkInterfaceProperties userPlaneDataInterface, IList<string> dnsAddresses, NaptConfiguration naptConfiguration, IList<string> userEquipmentAddressPoolPrefix, IList<string> userEquipmentStaticAddressPoolPrefix, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            ProvisioningState = provisioningState;
            UserPlaneDataInterface = userPlaneDataInterface;
            DnsAddresses = dnsAddresses;
            NaptConfiguration = naptConfiguration;
            UserEquipmentAddressPoolPrefix = userEquipmentAddressPoolPrefix;
            UserEquipmentStaticAddressPoolPrefix = userEquipmentStaticAddressPoolPrefix;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MobileAttachedDataNetworkData"/> for deserialization. </summary>
        internal MobileAttachedDataNetworkData()
        {
        }

        /// <summary>
        /// The provisioning state of the attached data network resource.
        /// Serialized Name: AttachedDataNetwork.properties.provisioningState
        /// </summary>
        [WirePath("properties.provisioningState")]
        public MobileNetworkProvisioningState? ProvisioningState { get; }
        /// <summary>
        /// The user plane interface on the data network. For 5G networks, this is the N6 interface. For 4G networks, this is the SGi interface.
        /// Serialized Name: AttachedDataNetwork.properties.userPlaneDataInterface
        /// </summary>
        [WirePath("properties.userPlaneDataInterface")]
        public MobileNetworkInterfaceProperties UserPlaneDataInterface { get; set; }
        /// <summary>
        /// The DNS servers to signal to UEs to use for this attached data network. This configuration is mandatory - if you don't want DNS servers, you must provide an empty array.
        /// Serialized Name: AttachedDataNetwork.properties.dnsAddresses
        /// </summary>
        [WirePath("properties.dnsAddresses")]
        public IList<string> DnsAddresses { get; }
        /// <summary>
        /// The network address and port translation (NAPT) configuration.
        /// If this is not specified, the attached data network will use a default NAPT configuration with NAPT enabled.
        /// Serialized Name: AttachedDataNetwork.properties.naptConfiguration
        /// </summary>
        [WirePath("properties.naptConfiguration")]
        public NaptConfiguration NaptConfiguration { get; set; }
        /// <summary>
        /// The user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will dynamically assign IP addresses to UEs.
        /// The packet core instance assigns an IP address to a UE when the UE sets up a PDU session.
        ///  You must define at least one of userEquipmentAddressPoolPrefix and userEquipmentStaticAddressPoolPrefix. If you define both, they must be of the same size.
        /// Serialized Name: AttachedDataNetwork.properties.userEquipmentAddressPoolPrefix
        /// </summary>
        [WirePath("properties.userEquipmentAddressPoolPrefix")]
        public IList<string> UserEquipmentAddressPoolPrefix { get; }
        /// <summary>
        /// The user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will assign static IP addresses to UEs.
        /// The packet core instance assigns an IP address to a UE when the UE sets up a PDU session. The static IP address for a specific UE is set in StaticIPConfiguration on the corresponding SIM resource.
        /// At least one of userEquipmentAddressPoolPrefix and userEquipmentStaticAddressPoolPrefix must be defined. If both are defined, they must be of the same size.
        /// Serialized Name: AttachedDataNetwork.properties.userEquipmentStaticAddressPoolPrefix
        /// </summary>
        [WirePath("properties.userEquipmentStaticAddressPoolPrefix")]
        public IList<string> UserEquipmentStaticAddressPoolPrefix { get; }
    }
}
