// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MobileNetwork
{
    internal class PacketCoreDataPlaneOperationSource : IOperationSource<PacketCoreDataPlaneResource>
    {
        private readonly ArmClient _client;

        internal PacketCoreDataPlaneOperationSource(ArmClient client)
        {
            _client = client;
        }

        PacketCoreDataPlaneResource IOperationSource<PacketCoreDataPlaneResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = PacketCoreDataPlaneData.DeserializePacketCoreDataPlaneData(document.RootElement);
            return new PacketCoreDataPlaneResource(_client, data);
        }

        async ValueTask<PacketCoreDataPlaneResource> IOperationSource<PacketCoreDataPlaneResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = PacketCoreDataPlaneData.DeserializePacketCoreDataPlaneData(document.RootElement);
            return new PacketCoreDataPlaneResource(_client, data);
        }
    }
}
