// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MobileNetwork
{
    internal class PacketCoreControlPlaneOperationSource : IOperationSource<PacketCoreControlPlaneResource>
    {
        private readonly ArmClient _client;

        internal PacketCoreControlPlaneOperationSource(ArmClient client)
        {
            _client = client;
        }

        PacketCoreControlPlaneResource IOperationSource<PacketCoreControlPlaneResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = PacketCoreControlPlaneData.DeserializePacketCoreControlPlaneData(document.RootElement);
            return new PacketCoreControlPlaneResource(_client, data);
        }

        async ValueTask<PacketCoreControlPlaneResource> IOperationSource<PacketCoreControlPlaneResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = PacketCoreControlPlaneData.DeserializePacketCoreControlPlaneData(document.RootElement);
            return new PacketCoreControlPlaneResource(_client, data);
        }
    }
}
