// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MobileNetwork
{
    internal class MobileNetworkSliceOperationSource : IOperationSource<MobileNetworkSliceResource>
    {
        private readonly ArmClient _client;

        internal MobileNetworkSliceOperationSource(ArmClient client)
        {
            _client = client;
        }

        MobileNetworkSliceResource IOperationSource<MobileNetworkSliceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MobileNetworkSliceData.DeserializeMobileNetworkSliceData(document.RootElement);
            return new MobileNetworkSliceResource(_client, data);
        }

        async ValueTask<MobileNetworkSliceResource> IOperationSource<MobileNetworkSliceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MobileNetworkSliceData.DeserializeMobileNetworkSliceData(document.RootElement);
            return new MobileNetworkSliceResource(_client, data);
        }
    }
}
