// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MobileNetwork
{
    internal class MobileNetworkSiteOperationSource : IOperationSource<MobileNetworkSiteResource>
    {
        private readonly ArmClient _client;

        internal MobileNetworkSiteOperationSource(ArmClient client)
        {
            _client = client;
        }

        MobileNetworkSiteResource IOperationSource<MobileNetworkSiteResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MobileNetworkSiteData.DeserializeMobileNetworkSiteData(document.RootElement);
            return new MobileNetworkSiteResource(_client, data);
        }

        async ValueTask<MobileNetworkSiteResource> IOperationSource<MobileNetworkSiteResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MobileNetworkSiteData.DeserializeMobileNetworkSiteData(document.RootElement);
            return new MobileNetworkSiteResource(_client, data);
        }
    }
}
