// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MobileNetwork
{
    internal class MobileNetworkSimPolicyOperationSource : IOperationSource<MobileNetworkSimPolicyResource>
    {
        private readonly ArmClient _client;

        internal MobileNetworkSimPolicyOperationSource(ArmClient client)
        {
            _client = client;
        }

        MobileNetworkSimPolicyResource IOperationSource<MobileNetworkSimPolicyResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MobileNetworkSimPolicyData.DeserializeMobileNetworkSimPolicyData(document.RootElement);
            return new MobileNetworkSimPolicyResource(_client, data);
        }

        async ValueTask<MobileNetworkSimPolicyResource> IOperationSource<MobileNetworkSimPolicyResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MobileNetworkSimPolicyData.DeserializeMobileNetworkSimPolicyData(document.RootElement);
            return new MobileNetworkSimPolicyResource(_client, data);
        }
    }
}
