// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MobileNetwork
{
    internal class MobileNetworkServiceOperationSource : IOperationSource<MobileNetworkServiceResource>
    {
        private readonly ArmClient _client;

        internal MobileNetworkServiceOperationSource(ArmClient client)
        {
            _client = client;
        }

        MobileNetworkServiceResource IOperationSource<MobileNetworkServiceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MobileNetworkServiceData.DeserializeMobileNetworkServiceData(document.RootElement);
            return new MobileNetworkServiceResource(_client, data);
        }

        async ValueTask<MobileNetworkServiceResource> IOperationSource<MobileNetworkServiceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MobileNetworkServiceData.DeserializeMobileNetworkServiceData(document.RootElement);
            return new MobileNetworkServiceResource(_client, data);
        }
    }
}
