// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MobileNetwork
{
    internal class MobileNetworkPacketCaptureOperationSource : IOperationSource<MobileNetworkPacketCaptureResource>
    {
        private readonly ArmClient _client;

        internal MobileNetworkPacketCaptureOperationSource(ArmClient client)
        {
            _client = client;
        }

        MobileNetworkPacketCaptureResource IOperationSource<MobileNetworkPacketCaptureResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MobileNetworkPacketCaptureData.DeserializeMobileNetworkPacketCaptureData(document.RootElement);
            return new MobileNetworkPacketCaptureResource(_client, data);
        }

        async ValueTask<MobileNetworkPacketCaptureResource> IOperationSource<MobileNetworkPacketCaptureResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MobileNetworkPacketCaptureData.DeserializeMobileNetworkPacketCaptureData(document.RootElement);
            return new MobileNetworkPacketCaptureResource(_client, data);
        }
    }
}
