// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MobileNetwork
{
    internal class MobileNetworkOperationSource : IOperationSource<MobileNetworkResource>
    {
        private readonly ArmClient _client;

        internal MobileNetworkOperationSource(ArmClient client)
        {
            _client = client;
        }

        MobileNetworkResource IOperationSource<MobileNetworkResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MobileNetworkData.DeserializeMobileNetworkData(document.RootElement);
            return new MobileNetworkResource(_client, data);
        }

        async ValueTask<MobileNetworkResource> IOperationSource<MobileNetworkResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MobileNetworkData.DeserializeMobileNetworkData(document.RootElement);
            return new MobileNetworkResource(_client, data);
        }
    }
}
