// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MobileNetwork
{
    internal class MobileDataNetworkOperationSource : IOperationSource<MobileDataNetworkResource>
    {
        private readonly ArmClient _client;

        internal MobileDataNetworkOperationSource(ArmClient client)
        {
            _client = client;
        }

        MobileDataNetworkResource IOperationSource<MobileDataNetworkResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MobileDataNetworkData.DeserializeMobileDataNetworkData(document.RootElement);
            return new MobileDataNetworkResource(_client, data);
        }

        async ValueTask<MobileDataNetworkResource> IOperationSource<MobileDataNetworkResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MobileDataNetworkData.DeserializeMobileDataNetworkData(document.RootElement);
            return new MobileDataNetworkResource(_client, data);
        }
    }
}
