// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MobileNetwork
{
    internal class MobileAttachedDataNetworkOperationSource : IOperationSource<MobileAttachedDataNetworkResource>
    {
        private readonly ArmClient _client;

        internal MobileAttachedDataNetworkOperationSource(ArmClient client)
        {
            _client = client;
        }

        MobileAttachedDataNetworkResource IOperationSource<MobileAttachedDataNetworkResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MobileAttachedDataNetworkData.DeserializeMobileAttachedDataNetworkData(document.RootElement);
            return new MobileAttachedDataNetworkResource(_client, data);
        }

        async ValueTask<MobileAttachedDataNetworkResource> IOperationSource<MobileAttachedDataNetworkResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MobileAttachedDataNetworkData.DeserializeMobileAttachedDataNetworkData(document.RootElement);
            return new MobileAttachedDataNetworkResource(_client, data);
        }
    }
}
