// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.MobileNetwork.Models;

namespace Azure.ResourceManager.MobileNetwork
{
    internal class AsyncOperationStatusOperationSource : IOperationSource<AsyncOperationStatus>
    {
        AsyncOperationStatus IOperationSource<AsyncOperationStatus>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return AsyncOperationStatus.DeserializeAsyncOperationStatus(document.RootElement);
        }

        async ValueTask<AsyncOperationStatus> IOperationSource<AsyncOperationStatus>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return AsyncOperationStatus.DeserializeAsyncOperationStatus(document.RootElement);
        }
    }
}
