// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.MobileNetwork.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableMobileNetworkArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableMobileNetworkArmClient"/> class for mocking. </summary>
        protected MockableMobileNetworkArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableMobileNetworkArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableMobileNetworkArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableMobileNetworkArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="MobileAttachedDataNetworkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MobileAttachedDataNetworkResource.CreateResourceIdentifier" /> to create a <see cref="MobileAttachedDataNetworkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MobileAttachedDataNetworkResource"/> object. </returns>
        public virtual MobileAttachedDataNetworkResource GetMobileAttachedDataNetworkResource(ResourceIdentifier id)
        {
            MobileAttachedDataNetworkResource.ValidateResourceId(id);
            return new MobileAttachedDataNetworkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MobileDataNetworkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MobileDataNetworkResource.CreateResourceIdentifier" /> to create a <see cref="MobileDataNetworkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MobileDataNetworkResource"/> object. </returns>
        public virtual MobileDataNetworkResource GetMobileDataNetworkResource(ResourceIdentifier id)
        {
            MobileDataNetworkResource.ValidateResourceId(id);
            return new MobileDataNetworkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MobileNetworkDiagnosticsPackageResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MobileNetworkDiagnosticsPackageResource.CreateResourceIdentifier" /> to create a <see cref="MobileNetworkDiagnosticsPackageResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MobileNetworkDiagnosticsPackageResource"/> object. </returns>
        public virtual MobileNetworkDiagnosticsPackageResource GetMobileNetworkDiagnosticsPackageResource(ResourceIdentifier id)
        {
            MobileNetworkDiagnosticsPackageResource.ValidateResourceId(id);
            return new MobileNetworkDiagnosticsPackageResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MobileNetworkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MobileNetworkResource.CreateResourceIdentifier" /> to create a <see cref="MobileNetworkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MobileNetworkResource"/> object. </returns>
        public virtual MobileNetworkResource GetMobileNetworkResource(ResourceIdentifier id)
        {
            MobileNetworkResource.ValidateResourceId(id);
            return new MobileNetworkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MobileNetworkPacketCaptureResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MobileNetworkPacketCaptureResource.CreateResourceIdentifier" /> to create a <see cref="MobileNetworkPacketCaptureResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MobileNetworkPacketCaptureResource"/> object. </returns>
        public virtual MobileNetworkPacketCaptureResource GetMobileNetworkPacketCaptureResource(ResourceIdentifier id)
        {
            MobileNetworkPacketCaptureResource.ValidateResourceId(id);
            return new MobileNetworkPacketCaptureResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PacketCoreControlPlaneResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PacketCoreControlPlaneResource.CreateResourceIdentifier" /> to create a <see cref="PacketCoreControlPlaneResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PacketCoreControlPlaneResource"/> object. </returns>
        public virtual PacketCoreControlPlaneResource GetPacketCoreControlPlaneResource(ResourceIdentifier id)
        {
            PacketCoreControlPlaneResource.ValidateResourceId(id);
            return new PacketCoreControlPlaneResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MobileNetworkRoutingInfoResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MobileNetworkRoutingInfoResource.CreateResourceIdentifier" /> to create a <see cref="MobileNetworkRoutingInfoResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MobileNetworkRoutingInfoResource"/> object. </returns>
        public virtual MobileNetworkRoutingInfoResource GetMobileNetworkRoutingInfoResource(ResourceIdentifier id)
        {
            MobileNetworkRoutingInfoResource.ValidateResourceId(id);
            return new MobileNetworkRoutingInfoResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="TenantPacketCoreControlPlaneVersionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="TenantPacketCoreControlPlaneVersionResource.CreateResourceIdentifier" /> to create a <see cref="TenantPacketCoreControlPlaneVersionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="TenantPacketCoreControlPlaneVersionResource"/> object. </returns>
        public virtual TenantPacketCoreControlPlaneVersionResource GetTenantPacketCoreControlPlaneVersionResource(ResourceIdentifier id)
        {
            TenantPacketCoreControlPlaneVersionResource.ValidateResourceId(id);
            return new TenantPacketCoreControlPlaneVersionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SubscriptionPacketCoreControlPlaneVersionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SubscriptionPacketCoreControlPlaneVersionResource.CreateResourceIdentifier" /> to create a <see cref="SubscriptionPacketCoreControlPlaneVersionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SubscriptionPacketCoreControlPlaneVersionResource"/> object. </returns>
        public virtual SubscriptionPacketCoreControlPlaneVersionResource GetSubscriptionPacketCoreControlPlaneVersionResource(ResourceIdentifier id)
        {
            SubscriptionPacketCoreControlPlaneVersionResource.ValidateResourceId(id);
            return new SubscriptionPacketCoreControlPlaneVersionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PacketCoreDataPlaneResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PacketCoreDataPlaneResource.CreateResourceIdentifier" /> to create a <see cref="PacketCoreDataPlaneResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PacketCoreDataPlaneResource"/> object. </returns>
        public virtual PacketCoreDataPlaneResource GetPacketCoreDataPlaneResource(ResourceIdentifier id)
        {
            PacketCoreDataPlaneResource.ValidateResourceId(id);
            return new PacketCoreDataPlaneResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MobileNetworkServiceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MobileNetworkServiceResource.CreateResourceIdentifier" /> to create a <see cref="MobileNetworkServiceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MobileNetworkServiceResource"/> object. </returns>
        public virtual MobileNetworkServiceResource GetMobileNetworkServiceResource(ResourceIdentifier id)
        {
            MobileNetworkServiceResource.ValidateResourceId(id);
            return new MobileNetworkServiceResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MobileNetworkSimResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MobileNetworkSimResource.CreateResourceIdentifier" /> to create a <see cref="MobileNetworkSimResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MobileNetworkSimResource"/> object. </returns>
        public virtual MobileNetworkSimResource GetMobileNetworkSimResource(ResourceIdentifier id)
        {
            MobileNetworkSimResource.ValidateResourceId(id);
            return new MobileNetworkSimResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MobileNetworkSimGroupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MobileNetworkSimGroupResource.CreateResourceIdentifier" /> to create a <see cref="MobileNetworkSimGroupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MobileNetworkSimGroupResource"/> object. </returns>
        public virtual MobileNetworkSimGroupResource GetMobileNetworkSimGroupResource(ResourceIdentifier id)
        {
            MobileNetworkSimGroupResource.ValidateResourceId(id);
            return new MobileNetworkSimGroupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MobileNetworkSimPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MobileNetworkSimPolicyResource.CreateResourceIdentifier" /> to create a <see cref="MobileNetworkSimPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MobileNetworkSimPolicyResource"/> object. </returns>
        public virtual MobileNetworkSimPolicyResource GetMobileNetworkSimPolicyResource(ResourceIdentifier id)
        {
            MobileNetworkSimPolicyResource.ValidateResourceId(id);
            return new MobileNetworkSimPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MobileNetworkSiteResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MobileNetworkSiteResource.CreateResourceIdentifier" /> to create a <see cref="MobileNetworkSiteResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MobileNetworkSiteResource"/> object. </returns>
        public virtual MobileNetworkSiteResource GetMobileNetworkSiteResource(ResourceIdentifier id)
        {
            MobileNetworkSiteResource.ValidateResourceId(id);
            return new MobileNetworkSiteResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MobileNetworkSliceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MobileNetworkSliceResource.CreateResourceIdentifier" /> to create a <see cref="MobileNetworkSliceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MobileNetworkSliceResource"/> object. </returns>
        public virtual MobileNetworkSliceResource GetMobileNetworkSliceResource(ResourceIdentifier id)
        {
            MobileNetworkSliceResource.ValidateResourceId(id);
            return new MobileNetworkSliceResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ExtendedUEInfoResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ExtendedUEInfoResource.CreateResourceIdentifier" /> to create an <see cref="ExtendedUEInfoResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ExtendedUEInfoResource"/> object. </returns>
        public virtual ExtendedUEInfoResource GetExtendedUEInfoResource(ResourceIdentifier id)
        {
            ExtendedUEInfoResource.ValidateResourceId(id);
            return new ExtendedUEInfoResource(Client, id);
        }
    }
}
