// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.MobileNetwork
{
    /// <summary>
    /// A class representing a collection of <see cref="ExtendedUEInfoResource"/> and their operations.
    /// Each <see cref="ExtendedUEInfoResource"/> in the collection will belong to the same instance of <see cref="PacketCoreControlPlaneResource"/>.
    /// To get an <see cref="ExtendedUEInfoCollection"/> instance call the GetExtendedUEInfos method from an instance of <see cref="PacketCoreControlPlaneResource"/>.
    /// </summary>
    public partial class ExtendedUEInfoCollection : ArmCollection
    {
        private readonly ClientDiagnostics _extendedUEInfoExtendedUEInformationClientDiagnostics;
        private readonly ExtendedUeInformationRestOperations _extendedUEInfoExtendedUEInformationRestClient;

        /// <summary> Initializes a new instance of the <see cref="ExtendedUEInfoCollection"/> class for mocking. </summary>
        protected ExtendedUEInfoCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ExtendedUEInfoCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal ExtendedUEInfoCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _extendedUEInfoExtendedUEInformationClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.MobileNetwork", ExtendedUEInfoResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ExtendedUEInfoResource.ResourceType, out string extendedUEInfoExtendedUEInformationApiVersion);
            _extendedUEInfoExtendedUEInformationRestClient = new ExtendedUeInformationRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, extendedUEInfoExtendedUEInformationApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != PacketCoreControlPlaneResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, PacketCoreControlPlaneResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets extended information about the specified UE from the packet core.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/ues/{ueId}/extendedInformation/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExtendedUeInformation_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ExtendedUEInfoResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ueId"> IMSI of a UE. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ueId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ueId"/> is null. </exception>
        public virtual async Task<Response<ExtendedUEInfoResource>> GetAsync(string ueId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ueId, nameof(ueId));

            using var scope = _extendedUEInfoExtendedUEInformationClientDiagnostics.CreateScope("ExtendedUEInfoCollection.Get");
            scope.Start();
            try
            {
                var response = await _extendedUEInfoExtendedUEInformationRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, ueId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ExtendedUEInfoResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets extended information about the specified UE from the packet core.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/ues/{ueId}/extendedInformation/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExtendedUeInformation_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ExtendedUEInfoResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ueId"> IMSI of a UE. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ueId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ueId"/> is null. </exception>
        public virtual Response<ExtendedUEInfoResource> Get(string ueId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ueId, nameof(ueId));

            using var scope = _extendedUEInfoExtendedUEInformationClientDiagnostics.CreateScope("ExtendedUEInfoCollection.Get");
            scope.Start();
            try
            {
                var response = _extendedUEInfoExtendedUEInformationRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, ueId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ExtendedUEInfoResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/ues/{ueId}/extendedInformation/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExtendedUeInformation_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ExtendedUEInfoResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ueId"> IMSI of a UE. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ueId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ueId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string ueId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ueId, nameof(ueId));

            using var scope = _extendedUEInfoExtendedUEInformationClientDiagnostics.CreateScope("ExtendedUEInfoCollection.Exists");
            scope.Start();
            try
            {
                var response = await _extendedUEInfoExtendedUEInformationRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, ueId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/ues/{ueId}/extendedInformation/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExtendedUeInformation_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ExtendedUEInfoResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ueId"> IMSI of a UE. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ueId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ueId"/> is null. </exception>
        public virtual Response<bool> Exists(string ueId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ueId, nameof(ueId));

            using var scope = _extendedUEInfoExtendedUEInformationClientDiagnostics.CreateScope("ExtendedUEInfoCollection.Exists");
            scope.Start();
            try
            {
                var response = _extendedUEInfoExtendedUEInformationRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, ueId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/ues/{ueId}/extendedInformation/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExtendedUeInformation_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ExtendedUEInfoResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ueId"> IMSI of a UE. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ueId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ueId"/> is null. </exception>
        public virtual async Task<NullableResponse<ExtendedUEInfoResource>> GetIfExistsAsync(string ueId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ueId, nameof(ueId));

            using var scope = _extendedUEInfoExtendedUEInformationClientDiagnostics.CreateScope("ExtendedUEInfoCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _extendedUEInfoExtendedUEInformationRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, ueId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<ExtendedUEInfoResource>(response.GetRawResponse());
                return Response.FromValue(new ExtendedUEInfoResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/ues/{ueId}/extendedInformation/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExtendedUeInformation_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ExtendedUEInfoResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ueId"> IMSI of a UE. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ueId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ueId"/> is null. </exception>
        public virtual NullableResponse<ExtendedUEInfoResource> GetIfExists(string ueId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ueId, nameof(ueId));

            using var scope = _extendedUEInfoExtendedUEInformationClientDiagnostics.CreateScope("ExtendedUEInfoCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _extendedUEInfoExtendedUEInformationRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, ueId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<ExtendedUEInfoResource>(response.GetRawResponse());
                return Response.FromValue(new ExtendedUEInfoResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
