// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.MobileNetwork.Samples
{
    public partial class Sample_SubscriptionPacketCoreControlPlaneVersionResource
    {
        // Get packet core control plane version by subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetPacketCoreControlPlaneVersionBySubscription()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/PacketCoreControlPlaneVersionGetBySubscription.json
            // this example is just showing the usage of "PacketCoreControlPlaneVersions_GetBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionPacketCoreControlPlaneVersionResource created on azure
            // for more information of creating SubscriptionPacketCoreControlPlaneVersionResource, please refer to the document of SubscriptionPacketCoreControlPlaneVersionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string versionName = "2404.0-1";
            ResourceIdentifier subscriptionPacketCoreControlPlaneVersionResourceId = SubscriptionPacketCoreControlPlaneVersionResource.CreateResourceIdentifier(subscriptionId, versionName);
            SubscriptionPacketCoreControlPlaneVersionResource subscriptionPacketCoreControlPlaneVersion = client.GetSubscriptionPacketCoreControlPlaneVersionResource(subscriptionPacketCoreControlPlaneVersionResourceId);

            // invoke the operation
            SubscriptionPacketCoreControlPlaneVersionResource result = await subscriptionPacketCoreControlPlaneVersion.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PacketCoreControlPlaneVersionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
