// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.MobileNetwork.Models;

namespace Azure.ResourceManager.MobileNetwork.Samples
{
    public partial class Sample_MobileNetworkSliceResource
    {
        // Delete network slice
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteNetworkSlice()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/SliceDelete.json
            // this example is just showing the usage of "Slices_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkSliceResource created on azure
            // for more information of creating MobileNetworkSliceResource, please refer to the document of MobileNetworkSliceResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string mobileNetworkName = "testMobileNetwork";
            string sliceName = "testSlice";
            ResourceIdentifier mobileNetworkSliceResourceId = MobileNetworkSliceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mobileNetworkName, sliceName);
            MobileNetworkSliceResource mobileNetworkSlice = client.GetMobileNetworkSliceResource(mobileNetworkSliceResourceId);

            // invoke the operation
            await mobileNetworkSlice.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Get network slice
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetNetworkSlice()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/SliceGet.json
            // this example is just showing the usage of "Slices_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkSliceResource created on azure
            // for more information of creating MobileNetworkSliceResource, please refer to the document of MobileNetworkSliceResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string mobileNetworkName = "testMobileNetwork";
            string sliceName = "testSlice";
            ResourceIdentifier mobileNetworkSliceResourceId = MobileNetworkSliceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mobileNetworkName, sliceName);
            MobileNetworkSliceResource mobileNetworkSlice = client.GetMobileNetworkSliceResource(mobileNetworkSliceResourceId);

            // invoke the operation
            MobileNetworkSliceResource result = await mobileNetworkSlice.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MobileNetworkSliceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update network slice tags
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateNetworkSliceTags()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/SliceUpdateTags.json
            // this example is just showing the usage of "Slices_UpdateTags" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkSliceResource created on azure
            // for more information of creating MobileNetworkSliceResource, please refer to the document of MobileNetworkSliceResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string mobileNetworkName = "testMobileNetwork";
            string sliceName = "testSlice";
            ResourceIdentifier mobileNetworkSliceResourceId = MobileNetworkSliceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mobileNetworkName, sliceName);
            MobileNetworkSliceResource mobileNetworkSlice = client.GetMobileNetworkSliceResource(mobileNetworkSliceResourceId);

            // invoke the operation
            MobileNetworkTagsPatch patch = new MobileNetworkTagsPatch()
            {
                Tags =
{
["tag1"] = "value1",
["tag2"] = "value2",
},
            };
            MobileNetworkSliceResource result = await mobileNetworkSlice.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MobileNetworkSliceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
