// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.MobileNetwork.Models;

namespace Azure.ResourceManager.MobileNetwork.Samples
{
    public partial class Sample_MobileNetworkSiteResource
    {
        // Delete mobile network site
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteMobileNetworkSite()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/SiteDelete.json
            // this example is just showing the usage of "Sites_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkSiteResource created on azure
            // for more information of creating MobileNetworkSiteResource, please refer to the document of MobileNetworkSiteResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string mobileNetworkName = "testMobileNetwork";
            string siteName = "testSite";
            ResourceIdentifier mobileNetworkSiteResourceId = MobileNetworkSiteResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mobileNetworkName, siteName);
            MobileNetworkSiteResource mobileNetworkSite = client.GetMobileNetworkSiteResource(mobileNetworkSiteResourceId);

            // invoke the operation
            await mobileNetworkSite.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Get mobile network site
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetMobileNetworkSite()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/SiteGet.json
            // this example is just showing the usage of "Sites_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkSiteResource created on azure
            // for more information of creating MobileNetworkSiteResource, please refer to the document of MobileNetworkSiteResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string mobileNetworkName = "testMobileNetwork";
            string siteName = "testSite";
            ResourceIdentifier mobileNetworkSiteResourceId = MobileNetworkSiteResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mobileNetworkName, siteName);
            MobileNetworkSiteResource mobileNetworkSite = client.GetMobileNetworkSiteResource(mobileNetworkSiteResourceId);

            // invoke the operation
            MobileNetworkSiteResource result = await mobileNetworkSite.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MobileNetworkSiteData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update mobile network site tags
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateMobileNetworkSiteTags()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/SiteUpdateTags.json
            // this example is just showing the usage of "Sites_UpdateTags" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkSiteResource created on azure
            // for more information of creating MobileNetworkSiteResource, please refer to the document of MobileNetworkSiteResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string mobileNetworkName = "testMobileNetwork";
            string siteName = "testSite";
            ResourceIdentifier mobileNetworkSiteResourceId = MobileNetworkSiteResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mobileNetworkName, siteName);
            MobileNetworkSiteResource mobileNetworkSite = client.GetMobileNetworkSiteResource(mobileNetworkSiteResourceId);

            // invoke the operation
            MobileNetworkTagsPatch patch = new MobileNetworkTagsPatch()
            {
                Tags =
{
["tag1"] = "value1",
["tag2"] = "value2",
},
            };
            MobileNetworkSiteResource result = await mobileNetworkSite.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MobileNetworkSiteData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete packet core in mobile network site
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task DeletePacketCore_DeletePacketCoreInMobileNetworkSite()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/SiteDeletePacketCore.json
            // this example is just showing the usage of "Sites_DeletePacketCore" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkSiteResource created on azure
            // for more information of creating MobileNetworkSiteResource, please refer to the document of MobileNetworkSiteResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string mobileNetworkName = "testMobileNetwork";
            string siteName = "testSite";
            ResourceIdentifier mobileNetworkSiteResourceId = MobileNetworkSiteResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mobileNetworkName, siteName);
            MobileNetworkSiteResource mobileNetworkSite = client.GetMobileNetworkSiteResource(mobileNetworkSiteResourceId);

            // invoke the operation
            SiteDeletePacketCore siteDeletePacketCore = new SiteDeletePacketCore();
            await mobileNetworkSite.DeletePacketCoreAsync(WaitUntil.Completed, siteDeletePacketCore);

            Console.WriteLine($"Succeeded");
        }
    }
}
