// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.MobileNetwork.Models;

namespace Azure.ResourceManager.MobileNetwork.Samples
{
    public partial class Sample_MobileNetworkSimResource
    {
        // Delete SIM
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteSIM()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/SimDelete.json
            // this example is just showing the usage of "Sims_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkSimResource created on azure
            // for more information of creating MobileNetworkSimResource, please refer to the document of MobileNetworkSimResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "testResourceGroupName";
            string simGroupName = "testSimGroup";
            string simName = "testSim";
            ResourceIdentifier mobileNetworkSimResourceId = MobileNetworkSimResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, simGroupName, simName);
            MobileNetworkSimResource mobileNetworkSim = client.GetMobileNetworkSimResource(mobileNetworkSimResourceId);

            // invoke the operation
            await mobileNetworkSim.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Get SIM
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetSIM()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/SimGet.json
            // this example is just showing the usage of "Sims_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkSimResource created on azure
            // for more information of creating MobileNetworkSimResource, please refer to the document of MobileNetworkSimResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "testResourceGroupName";
            string simGroupName = "testSimGroup";
            string simName = "testSimName";
            ResourceIdentifier mobileNetworkSimResourceId = MobileNetworkSimResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, simGroupName, simName);
            MobileNetworkSimResource mobileNetworkSim = client.GetMobileNetworkSimResource(mobileNetworkSimResourceId);

            // invoke the operation
            MobileNetworkSimResource result = await mobileNetworkSim.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MobileNetworkSimData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create SIM
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateSIM()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/SimCreate.json
            // this example is just showing the usage of "Sims_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkSimResource created on azure
            // for more information of creating MobileNetworkSimResource, please refer to the document of MobileNetworkSimResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string simGroupName = "testSimGroup";
            string simName = "testSim";
            ResourceIdentifier mobileNetworkSimResourceId = MobileNetworkSimResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, simGroupName, simName);
            MobileNetworkSimResource mobileNetworkSim = client.GetMobileNetworkSimResource(mobileNetworkSimResourceId);

            // invoke the operation
            MobileNetworkSimData data = new MobileNetworkSimData("00000")
            {
                IntegratedCircuitCardIdentifier = "8900000000000000000",
                DeviceType = "Video camera",
                SimPolicyId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/simPolicies/MySimPolicy"),
                StaticIPConfiguration =
{
new SimStaticIPProperties()
{
AttachedDataNetworkId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP/packetCoreDataPlanes/TestPacketCoreDP/attachedDataNetworks/TestAttachedDataNetwork"),
SliceId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/slices/testSlice"),
StaticIPIPv4Address = "2.4.0.1",
}
},
                AuthenticationKey = "00000000000000000000000000000000",
                OperatorKeyCode = "00000000000000000000000000000000",
            };
            ArmOperation<MobileNetworkSimResource> lro = await mobileNetworkSim.UpdateAsync(WaitUntil.Completed, data);
            MobileNetworkSimResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MobileNetworkSimData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
