// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.MobileNetwork.Models;

namespace Azure.ResourceManager.MobileNetwork.Samples
{
    public partial class Sample_MobileNetworkSimPolicyResource
    {
        // Delete SIM policy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteSIMPolicy()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/SimPolicyDelete.json
            // this example is just showing the usage of "SimPolicies_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkSimPolicyResource created on azure
            // for more information of creating MobileNetworkSimPolicyResource, please refer to the document of MobileNetworkSimPolicyResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string mobileNetworkName = "testMobileNetwork";
            string simPolicyName = "testPolicy";
            ResourceIdentifier mobileNetworkSimPolicyResourceId = MobileNetworkSimPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mobileNetworkName, simPolicyName);
            MobileNetworkSimPolicyResource mobileNetworkSimPolicy = client.GetMobileNetworkSimPolicyResource(mobileNetworkSimPolicyResourceId);

            // invoke the operation
            await mobileNetworkSimPolicy.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Get SIM policy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetSIMPolicy()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/SimPolicyGet.json
            // this example is just showing the usage of "SimPolicies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkSimPolicyResource created on azure
            // for more information of creating MobileNetworkSimPolicyResource, please refer to the document of MobileNetworkSimPolicyResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string mobileNetworkName = "testMobileNetwork";
            string simPolicyName = "testPolicy";
            ResourceIdentifier mobileNetworkSimPolicyResourceId = MobileNetworkSimPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mobileNetworkName, simPolicyName);
            MobileNetworkSimPolicyResource mobileNetworkSimPolicy = client.GetMobileNetworkSimPolicyResource(mobileNetworkSimPolicyResourceId);

            // invoke the operation
            MobileNetworkSimPolicyResource result = await mobileNetworkSimPolicy.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MobileNetworkSimPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update SIM policy tags
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateSIMPolicyTags()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/SimPolicyUpdateTags.json
            // this example is just showing the usage of "SimPolicies_UpdateTags" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkSimPolicyResource created on azure
            // for more information of creating MobileNetworkSimPolicyResource, please refer to the document of MobileNetworkSimPolicyResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string mobileNetworkName = "testMobileNetwork";
            string simPolicyName = "testPolicy";
            ResourceIdentifier mobileNetworkSimPolicyResourceId = MobileNetworkSimPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mobileNetworkName, simPolicyName);
            MobileNetworkSimPolicyResource mobileNetworkSimPolicy = client.GetMobileNetworkSimPolicyResource(mobileNetworkSimPolicyResourceId);

            // invoke the operation
            MobileNetworkTagsPatch patch = new MobileNetworkTagsPatch()
            {
                Tags =
{
["tag1"] = "value1",
["tag2"] = "value2",
},
            };
            MobileNetworkSimPolicyResource result = await mobileNetworkSimPolicy.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MobileNetworkSimPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
