// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.MobileNetwork.Models;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.MobileNetwork.Samples
{
    public partial class Sample_MobileNetworkSimGroupResource
    {
        // Bulk upload SIMs in a SIM group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task BulkUploadSim_BulkUploadSIMsInASIMGroup()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/SimBulkUpload.json
            // this example is just showing the usage of "Sims_BulkUpload" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkSimGroupResource created on azure
            // for more information of creating MobileNetworkSimGroupResource, please refer to the document of MobileNetworkSimGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string simGroupName = "testSimGroup";
            ResourceIdentifier mobileNetworkSimGroupResourceId = MobileNetworkSimGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, simGroupName);
            MobileNetworkSimGroupResource mobileNetworkSimGroup = client.GetMobileNetworkSimGroupResource(mobileNetworkSimGroupResourceId);

            // invoke the operation
            SimUploadList simUploadList = new SimUploadList(new SimNameAndProperties[]
            {
new SimNameAndProperties("testSim","00000")
{
IntegratedCircuitCardIdentifier = "8900000000000000000",
DeviceType = "Video camera",
SimPolicyId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/simPolicies/MySimPolicy"),
StaticIPConfiguration =
{
new SimStaticIPProperties()
{
AttachedDataNetworkId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP/packetCoreDataPlanes/TestPacketCoreDP/attachedDataNetworks/TestAttachedDataNetwork"),
SliceId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/slices/testSlice"),
StaticIPIPv4Address = "2.4.0.1",
}
},
AuthenticationKey = "00000000000000000000000000000000",
OperatorKeyCode = "00000000000000000000000000000000",
},new SimNameAndProperties("testSim2","00000")
{
IntegratedCircuitCardIdentifier = "8900000000000000001",
DeviceType = "Video camera",
SimPolicyId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/simPolicies/MySimPolicy"),
StaticIPConfiguration =
{
new SimStaticIPProperties()
{
AttachedDataNetworkId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP/packetCoreDataPlanes/TestPacketCoreDP/attachedDataNetworks/TestAttachedDataNetwork"),
SliceId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/slices/testSlice"),
StaticIPIPv4Address = "2.4.0.2",
}
},
AuthenticationKey = "00000000000000000000000000000000",
OperatorKeyCode = "00000000000000000000000000000000",
}
            });
            ArmOperation<AsyncOperationStatus> lro = await mobileNetworkSimGroup.BulkUploadSimAsync(WaitUntil.Completed, simUploadList);
            AsyncOperationStatus result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // Bulk delete SIMs from a SIM group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task BulkDeleteSim_BulkDeleteSIMsFromASIMGroup()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/SimBulkDelete.json
            // this example is just showing the usage of "Sims_BulkDelete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkSimGroupResource created on azure
            // for more information of creating MobileNetworkSimGroupResource, please refer to the document of MobileNetworkSimGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "testResourceGroupName";
            string simGroupName = "testSimGroup";
            ResourceIdentifier mobileNetworkSimGroupResourceId = MobileNetworkSimGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, simGroupName);
            MobileNetworkSimGroupResource mobileNetworkSimGroup = client.GetMobileNetworkSimGroupResource(mobileNetworkSimGroupResourceId);

            // invoke the operation
            SimDeleteList simDeleteList = new SimDeleteList(new string[]
            {
"testSim","testSim2"
            });
            ArmOperation<AsyncOperationStatus> lro = await mobileNetworkSimGroup.BulkDeleteSimAsync(WaitUntil.Completed, simDeleteList);
            AsyncOperationStatus result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // Bulk upload encrypted SIMs to a SIM group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task BulkUploadEncryptedSim_BulkUploadEncryptedSIMsToASIMGroup()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/SimBulkUploadEncrypted.json
            // this example is just showing the usage of "Sims_BulkUploadEncrypted" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkSimGroupResource created on azure
            // for more information of creating MobileNetworkSimGroupResource, please refer to the document of MobileNetworkSimGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string simGroupName = "testSimGroup";
            ResourceIdentifier mobileNetworkSimGroupResourceId = MobileNetworkSimGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, simGroupName);
            MobileNetworkSimGroupResource mobileNetworkSimGroup = client.GetMobileNetworkSimGroupResource(mobileNetworkSimGroupResourceId);

            // invoke the operation
            EncryptedSimUploadList encryptedSimUploadList = new EncryptedSimUploadList(1, 1, "ABC123", "ABC123", "ABC123", new SimNameAndEncryptedProperties[]
            {
new SimNameAndEncryptedProperties("testSim","00000")
{
IntegratedCircuitCardIdentifier = "8900000000000000000",
DeviceType = "Video camera",
SimPolicyId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/simPolicies/MySimPolicy"),
StaticIPConfiguration =
{
new SimStaticIPProperties()
{
AttachedDataNetworkId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP/packetCoreDataPlanes/TestPacketCoreDP/attachedDataNetworks/TestAttachedDataNetwork"),
SliceId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/slices/testSlice"),
StaticIPIPv4Address = "2.4.0.1",
}
},
EncryptedCredentials = "ABC123",
},new SimNameAndEncryptedProperties("testSim2","00000")
{
IntegratedCircuitCardIdentifier = "8900000000000000001",
DeviceType = "Video camera",
SimPolicyId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/simPolicies/MySimPolicy"),
StaticIPConfiguration =
{
new SimStaticIPProperties()
{
AttachedDataNetworkId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP/packetCoreDataPlanes/TestPacketCoreDP/attachedDataNetworks/TestAttachedDataNetwork"),
SliceId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/slices/testSlice"),
StaticIPIPv4Address = "2.4.0.2",
}
},
EncryptedCredentials = "ABC123",
}
            });
            ArmOperation<AsyncOperationStatus> lro = await mobileNetworkSimGroup.BulkUploadEncryptedSimAsync(WaitUntil.Completed, encryptedSimUploadList);
            AsyncOperationStatus result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // Move list of SIMs to target SIM group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task MoveSim_MoveListOfSIMsToTargetSIMGroup()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/SimMove.json
            // this example is just showing the usage of "Sims_Move" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkSimGroupResource created on azure
            // for more information of creating MobileNetworkSimGroupResource, please refer to the document of MobileNetworkSimGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "testResourceGroupName";
            string simGroupName = "testSimGroup";
            ResourceIdentifier mobileNetworkSimGroupResourceId = MobileNetworkSimGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, simGroupName);
            MobileNetworkSimGroupResource mobileNetworkSimGroup = client.GetMobileNetworkSimGroupResource(mobileNetworkSimGroupResourceId);

            // invoke the operation
            SimMoveContent content = new SimMoveContent()
            {
                Sims =
{
"testSim","testSim2"
},
            };
            ArmOperation<AsyncOperationStatus> lro = await mobileNetworkSimGroup.MoveSimAsync(WaitUntil.Completed, content);
            AsyncOperationStatus result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // Clone list of SIMs to target SIM group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CloneSim_CloneListOfSIMsToTargetSIMGroup()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/SimClone.json
            // this example is just showing the usage of "Sims_Clone" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkSimGroupResource created on azure
            // for more information of creating MobileNetworkSimGroupResource, please refer to the document of MobileNetworkSimGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "testResourceGroupName";
            string simGroupName = "testSimGroup";
            ResourceIdentifier mobileNetworkSimGroupResourceId = MobileNetworkSimGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, simGroupName);
            MobileNetworkSimGroupResource mobileNetworkSimGroup = client.GetMobileNetworkSimGroupResource(mobileNetworkSimGroupResourceId);

            // invoke the operation
            SimCloneContent content = new SimCloneContent()
            {
                Sims =
{
"testSim","testSim2"
},
            };
            ArmOperation<AsyncOperationStatus> lro = await mobileNetworkSimGroup.CloneSimAsync(WaitUntil.Completed, content);
            AsyncOperationStatus result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // Delete SIM group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteSIMGroup()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/SimGroupDelete.json
            // this example is just showing the usage of "SimGroups_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkSimGroupResource created on azure
            // for more information of creating MobileNetworkSimGroupResource, please refer to the document of MobileNetworkSimGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "testResourceGroupName";
            string simGroupName = "testSimGroup";
            ResourceIdentifier mobileNetworkSimGroupResourceId = MobileNetworkSimGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, simGroupName);
            MobileNetworkSimGroupResource mobileNetworkSimGroup = client.GetMobileNetworkSimGroupResource(mobileNetworkSimGroupResourceId);

            // invoke the operation
            await mobileNetworkSimGroup.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Get SIM group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetSIMGroup()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/SimGroupGet.json
            // this example is just showing the usage of "SimGroups_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkSimGroupResource created on azure
            // for more information of creating MobileNetworkSimGroupResource, please refer to the document of MobileNetworkSimGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "testResourceGroupName";
            string simGroupName = "testSimGroupName";
            ResourceIdentifier mobileNetworkSimGroupResourceId = MobileNetworkSimGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, simGroupName);
            MobileNetworkSimGroupResource mobileNetworkSimGroup = client.GetMobileNetworkSimGroupResource(mobileNetworkSimGroupResourceId);

            // invoke the operation
            MobileNetworkSimGroupResource result = await mobileNetworkSimGroup.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MobileNetworkSimGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Patch SIM group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_PatchSIMGroup()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/SimGroupPatch.json
            // this example is just showing the usage of "SimGroups_UpdateTags" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkSimGroupResource created on azure
            // for more information of creating MobileNetworkSimGroupResource, please refer to the document of MobileNetworkSimGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string simGroupName = "testSimGroup";
            ResourceIdentifier mobileNetworkSimGroupResourceId = MobileNetworkSimGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, simGroupName);
            MobileNetworkSimGroupResource mobileNetworkSimGroup = client.GetMobileNetworkSimGroupResource(mobileNetworkSimGroupResourceId);

            // invoke the operation
            MobileNetworkResourcePatch patch = new MobileNetworkResourcePatch()
            {
                UserAssignedIdentity = new MobileNetworkManagedServiceIdentity(MobileNetworkManagedServiceIdentityType.UserAssigned)
                {
                    UserAssignedIdentities =
{
["/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testUserAssignedManagedIdentity"] = new UserAssignedIdentity(),
},
                },
                Tags =
{
["tag1"] = "value1",
["tag2"] = "value2",
},
            };
            MobileNetworkSimGroupResource result = await mobileNetworkSimGroup.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MobileNetworkSimGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // List SIM groups in a subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetMobileNetworkSimGroups_ListSIMGroupsInASubscription()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/SimGroupListBySubscription.json
            // this example is just showing the usage of "SimGroups_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (MobileNetworkSimGroupResource item in subscriptionResource.GetMobileNetworkSimGroupsAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                MobileNetworkSimGroupData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
