// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.MobileNetwork.Models;

namespace Azure.ResourceManager.MobileNetwork.Samples
{
    public partial class Sample_MobileNetworkServiceResource
    {
        // Delete service
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteService()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/ServiceDelete.json
            // this example is just showing the usage of "Services_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkServiceResource created on azure
            // for more information of creating MobileNetworkServiceResource, please refer to the document of MobileNetworkServiceResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string mobileNetworkName = "testMobileNetwork";
            string serviceName = "TestService";
            ResourceIdentifier mobileNetworkServiceResourceId = MobileNetworkServiceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mobileNetworkName, serviceName);
            MobileNetworkServiceResource mobileNetworkService = client.GetMobileNetworkServiceResource(mobileNetworkServiceResourceId);

            // invoke the operation
            await mobileNetworkService.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Get service
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetService()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/ServiceGet.json
            // this example is just showing the usage of "Services_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkServiceResource created on azure
            // for more information of creating MobileNetworkServiceResource, please refer to the document of MobileNetworkServiceResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string mobileNetworkName = "testMobileNetwork";
            string serviceName = "TestService";
            ResourceIdentifier mobileNetworkServiceResourceId = MobileNetworkServiceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mobileNetworkName, serviceName);
            MobileNetworkServiceResource mobileNetworkService = client.GetMobileNetworkServiceResource(mobileNetworkServiceResourceId);

            // invoke the operation
            MobileNetworkServiceResource result = await mobileNetworkService.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MobileNetworkServiceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update service tags
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateServiceTags()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/ServiceUpdateTags.json
            // this example is just showing the usage of "Services_UpdateTags" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkServiceResource created on azure
            // for more information of creating MobileNetworkServiceResource, please refer to the document of MobileNetworkServiceResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string mobileNetworkName = "testMobileNetwork";
            string serviceName = "TestService";
            ResourceIdentifier mobileNetworkServiceResourceId = MobileNetworkServiceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mobileNetworkName, serviceName);
            MobileNetworkServiceResource mobileNetworkService = client.GetMobileNetworkServiceResource(mobileNetworkServiceResourceId);

            // invoke the operation
            MobileNetworkTagsPatch patch = new MobileNetworkTagsPatch()
            {
                Tags =
{
["tag1"] = "value1",
["tag2"] = "value2",
},
            };
            MobileNetworkServiceResource result = await mobileNetworkService.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MobileNetworkServiceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
