// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.MobileNetwork.Samples
{
    public partial class Sample_MobileNetworkDiagnosticsPackageResource
    {
        // Create diagnostics package
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateDiagnosticsPackage()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/DiagnosticsPackageCreate.json
            // this example is just showing the usage of "DiagnosticsPackages_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkDiagnosticsPackageResource created on azure
            // for more information of creating MobileNetworkDiagnosticsPackageResource, please refer to the document of MobileNetworkDiagnosticsPackageResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string packetCoreControlPlaneName = "TestPacketCoreCP";
            string diagnosticsPackageName = "dp1";
            ResourceIdentifier mobileNetworkDiagnosticsPackageResourceId = MobileNetworkDiagnosticsPackageResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, packetCoreControlPlaneName, diagnosticsPackageName);
            MobileNetworkDiagnosticsPackageResource mobileNetworkDiagnosticsPackage = client.GetMobileNetworkDiagnosticsPackageResource(mobileNetworkDiagnosticsPackageResourceId);

            // invoke the operation
            ArmOperation<MobileNetworkDiagnosticsPackageResource> lro = await mobileNetworkDiagnosticsPackage.UpdateAsync(WaitUntil.Completed);
            MobileNetworkDiagnosticsPackageResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MobileNetworkDiagnosticsPackageData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get diagnostics package
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetDiagnosticsPackage()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/DiagnosticsPackageGet.json
            // this example is just showing the usage of "DiagnosticsPackages_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkDiagnosticsPackageResource created on azure
            // for more information of creating MobileNetworkDiagnosticsPackageResource, please refer to the document of MobileNetworkDiagnosticsPackageResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string packetCoreControlPlaneName = "TestPacketCoreCP";
            string diagnosticsPackageName = "dp1";
            ResourceIdentifier mobileNetworkDiagnosticsPackageResourceId = MobileNetworkDiagnosticsPackageResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, packetCoreControlPlaneName, diagnosticsPackageName);
            MobileNetworkDiagnosticsPackageResource mobileNetworkDiagnosticsPackage = client.GetMobileNetworkDiagnosticsPackageResource(mobileNetworkDiagnosticsPackageResourceId);

            // invoke the operation
            MobileNetworkDiagnosticsPackageResource result = await mobileNetworkDiagnosticsPackage.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MobileNetworkDiagnosticsPackageData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete diagnostics package
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteDiagnosticsPackage()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/DiagnosticsPackageDelete.json
            // this example is just showing the usage of "DiagnosticsPackages_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkDiagnosticsPackageResource created on azure
            // for more information of creating MobileNetworkDiagnosticsPackageResource, please refer to the document of MobileNetworkDiagnosticsPackageResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string packetCoreControlPlaneName = "TestPacketCoreCP";
            string diagnosticsPackageName = "dp1";
            ResourceIdentifier mobileNetworkDiagnosticsPackageResourceId = MobileNetworkDiagnosticsPackageResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, packetCoreControlPlaneName, diagnosticsPackageName);
            MobileNetworkDiagnosticsPackageResource mobileNetworkDiagnosticsPackage = client.GetMobileNetworkDiagnosticsPackageResource(mobileNetworkDiagnosticsPackageResourceId);

            // invoke the operation
            await mobileNetworkDiagnosticsPackage.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
