// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.MobileNetwork.Models;

namespace Azure.ResourceManager.MobileNetwork.Samples
{
    public partial class Sample_MobileDataNetworkResource
    {
        // Delete data network
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteDataNetwork()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/DataNetworkDelete.json
            // this example is just showing the usage of "DataNetworks_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileDataNetworkResource created on azure
            // for more information of creating MobileDataNetworkResource, please refer to the document of MobileDataNetworkResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string mobileNetworkName = "testMobileNetwork";
            string dataNetworkName = "testDataNetwork";
            ResourceIdentifier mobileDataNetworkResourceId = MobileDataNetworkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mobileNetworkName, dataNetworkName);
            MobileDataNetworkResource mobileDataNetwork = client.GetMobileDataNetworkResource(mobileDataNetworkResourceId);

            // invoke the operation
            await mobileDataNetwork.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Get data network
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetDataNetwork()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/DataNetworkGet.json
            // this example is just showing the usage of "DataNetworks_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileDataNetworkResource created on azure
            // for more information of creating MobileDataNetworkResource, please refer to the document of MobileDataNetworkResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string mobileNetworkName = "testMobileNetwork";
            string dataNetworkName = "testDataNetwork";
            ResourceIdentifier mobileDataNetworkResourceId = MobileDataNetworkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mobileNetworkName, dataNetworkName);
            MobileDataNetworkResource mobileDataNetwork = client.GetMobileDataNetworkResource(mobileDataNetworkResourceId);

            // invoke the operation
            MobileDataNetworkResource result = await mobileDataNetwork.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MobileDataNetworkData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update data network tags
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateDataNetworkTags()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/DataNetworkUpdateTags.json
            // this example is just showing the usage of "DataNetworks_UpdateTags" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileDataNetworkResource created on azure
            // for more information of creating MobileDataNetworkResource, please refer to the document of MobileDataNetworkResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string mobileNetworkName = "testMobileNetwork";
            string dataNetworkName = "testDataNetwork";
            ResourceIdentifier mobileDataNetworkResourceId = MobileDataNetworkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mobileNetworkName, dataNetworkName);
            MobileDataNetworkResource mobileDataNetwork = client.GetMobileDataNetworkResource(mobileDataNetworkResourceId);

            // invoke the operation
            MobileNetworkTagsPatch patch = new MobileNetworkTagsPatch()
            {
                Tags =
{
["tag1"] = "value1",
["tag2"] = "value2",
},
            };
            MobileDataNetworkResource result = await mobileDataNetwork.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MobileDataNetworkData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
