// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.MobileNetwork.Samples
{
    public partial class Sample_MobileDataNetworkCollection
    {
        // Get data network
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetDataNetwork()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/DataNetworkGet.json
            // this example is just showing the usage of "DataNetworks_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkResource created on azure
            // for more information of creating MobileNetworkResource, please refer to the document of MobileNetworkResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string mobileNetworkName = "testMobileNetwork";
            ResourceIdentifier mobileNetworkResourceId = MobileNetworkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mobileNetworkName);
            MobileNetworkResource mobileNetwork = client.GetMobileNetworkResource(mobileNetworkResourceId);

            // get the collection of this MobileDataNetworkResource
            MobileDataNetworkCollection collection = mobileNetwork.GetMobileDataNetworks();

            // invoke the operation
            string dataNetworkName = "testDataNetwork";
            MobileDataNetworkResource result = await collection.GetAsync(dataNetworkName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MobileDataNetworkData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get data network
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetDataNetwork()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/DataNetworkGet.json
            // this example is just showing the usage of "DataNetworks_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkResource created on azure
            // for more information of creating MobileNetworkResource, please refer to the document of MobileNetworkResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string mobileNetworkName = "testMobileNetwork";
            ResourceIdentifier mobileNetworkResourceId = MobileNetworkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mobileNetworkName);
            MobileNetworkResource mobileNetwork = client.GetMobileNetworkResource(mobileNetworkResourceId);

            // get the collection of this MobileDataNetworkResource
            MobileDataNetworkCollection collection = mobileNetwork.GetMobileDataNetworks();

            // invoke the operation
            string dataNetworkName = "testDataNetwork";
            bool result = await collection.ExistsAsync(dataNetworkName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get data network
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetDataNetwork()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/DataNetworkGet.json
            // this example is just showing the usage of "DataNetworks_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkResource created on azure
            // for more information of creating MobileNetworkResource, please refer to the document of MobileNetworkResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string mobileNetworkName = "testMobileNetwork";
            ResourceIdentifier mobileNetworkResourceId = MobileNetworkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mobileNetworkName);
            MobileNetworkResource mobileNetwork = client.GetMobileNetworkResource(mobileNetworkResourceId);

            // get the collection of this MobileDataNetworkResource
            MobileDataNetworkCollection collection = mobileNetwork.GetMobileDataNetworks();

            // invoke the operation
            string dataNetworkName = "testDataNetwork";
            NullableResponse<MobileDataNetworkResource> response = await collection.GetIfExistsAsync(dataNetworkName);
            MobileDataNetworkResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                MobileDataNetworkData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Create data network
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateDataNetwork()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/DataNetworkCreate.json
            // this example is just showing the usage of "DataNetworks_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkResource created on azure
            // for more information of creating MobileNetworkResource, please refer to the document of MobileNetworkResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string mobileNetworkName = "testMobileNetwork";
            ResourceIdentifier mobileNetworkResourceId = MobileNetworkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mobileNetworkName);
            MobileNetworkResource mobileNetwork = client.GetMobileNetworkResource(mobileNetworkResourceId);

            // get the collection of this MobileDataNetworkResource
            MobileDataNetworkCollection collection = mobileNetwork.GetMobileDataNetworks();

            // invoke the operation
            string dataNetworkName = "testDataNetwork";
            MobileDataNetworkData data = new MobileDataNetworkData(new AzureLocation("eastus"))
            {
                Description = "myFavouriteDataNetwork",
            };
            ArmOperation<MobileDataNetworkResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, dataNetworkName, data);
            MobileDataNetworkResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MobileDataNetworkData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // List data networks in a mobile network
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListDataNetworksInAMobileNetwork()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/DataNetworkListByMobileNetwork.json
            // this example is just showing the usage of "DataNetworks_ListByMobileNetwork" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MobileNetworkResource created on azure
            // for more information of creating MobileNetworkResource, please refer to the document of MobileNetworkResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string mobileNetworkName = "testMobileNetwork";
            ResourceIdentifier mobileNetworkResourceId = MobileNetworkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mobileNetworkName);
            MobileNetworkResource mobileNetwork = client.GetMobileNetworkResource(mobileNetworkResourceId);

            // get the collection of this MobileDataNetworkResource
            MobileDataNetworkCollection collection = mobileNetwork.GetMobileDataNetworks();

            // invoke the operation and iterate over the result
            await foreach (MobileDataNetworkResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                MobileDataNetworkData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
