// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.MobileNetwork.Samples
{
    public partial class Sample_ExtendedUEInfoResource
    {
        // Get UE Information 4G
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetUEInformation4G()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/ExtendedUeInfo4GGet.json
            // this example is just showing the usage of "ExtendedUeInformation_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ExtendedUEInfoResource created on azure
            // for more information of creating ExtendedUEInfoResource, please refer to the document of ExtendedUEInfoResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string packetCoreControlPlaneName = "TestPacketCoreCP";
            string ueId = "84449105622";
            ResourceIdentifier extendedUEInfoResourceId = ExtendedUEInfoResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, packetCoreControlPlaneName, ueId);
            ExtendedUEInfoResource extendedUEInfo = client.GetExtendedUEInfoResource(extendedUEInfoResourceId);

            // invoke the operation
            ExtendedUEInfoResource result = await extendedUEInfo.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ExtendedUEInfoData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get UE Information 5G
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetUEInformation5G()
        {
            // Generated from example definition: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-04-01/examples/ExtendedUeInfo5GGet.json
            // this example is just showing the usage of "ExtendedUeInformation_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ExtendedUEInfoResource created on azure
            // for more information of creating ExtendedUEInfoResource, please refer to the document of ExtendedUEInfoResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string packetCoreControlPlaneName = "TestPacketCoreCP";
            string ueId = "84449105622";
            ResourceIdentifier extendedUEInfoResourceId = ExtendedUEInfoResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, packetCoreControlPlaneName, ueId);
            ExtendedUEInfoResource extendedUEInfo = client.GetExtendedUEInfoResource(extendedUEInfoResourceId);

            // invoke the operation
            ExtendedUEInfoResource result = await extendedUEInfo.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ExtendedUEInfoData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
