// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.MixedReality.Models
{
    internal static partial class MixedRealitySkuTierExtensions
    {
        public static string ToSerialString(this MixedRealitySkuTier value) => value switch
        {
            MixedRealitySkuTier.Free => "Free",
            MixedRealitySkuTier.Basic => "Basic",
            MixedRealitySkuTier.Standard => "Standard",
            MixedRealitySkuTier.Premium => "Premium",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown MixedRealitySkuTier value.")
        };

        public static MixedRealitySkuTier ToMixedRealitySkuTier(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Free")) return MixedRealitySkuTier.Free;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Basic")) return MixedRealitySkuTier.Basic;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Standard")) return MixedRealitySkuTier.Standard;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Premium")) return MixedRealitySkuTier.Premium;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown MixedRealitySkuTier value.");
        }
    }
}
