// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MixedReality.Models
{
    /// <summary> Check Name Availability Response. </summary>
    public partial class MixedRealityNameAvailabilityResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MixedRealityNameAvailabilityResult"/>. </summary>
        /// <param name="isNameAvailable"> if name Available. </param>
        internal MixedRealityNameAvailabilityResult(bool isNameAvailable)
        {
            IsNameAvailable = isNameAvailable;
        }

        /// <summary> Initializes a new instance of <see cref="MixedRealityNameAvailabilityResult"/>. </summary>
        /// <param name="isNameAvailable"> if name Available. </param>
        /// <param name="reason"> Resource Name To Verify. </param>
        /// <param name="message"> detail message. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MixedRealityNameAvailabilityResult(bool isNameAvailable, MixedRealityNameUnavailableReason? reason, string message, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsNameAvailable = isNameAvailable;
            Reason = reason;
            Message = message;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MixedRealityNameAvailabilityResult"/> for deserialization. </summary>
        internal MixedRealityNameAvailabilityResult()
        {
        }

        /// <summary> if name Available. </summary>
        public bool IsNameAvailable { get; }
        /// <summary> Resource Name To Verify. </summary>
        public MixedRealityNameUnavailableReason? Reason { get; }
        /// <summary> detail message. </summary>
        public string Message { get; }
    }
}
