// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.MixedReality.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.MixedReality.Samples
{
    public partial class Sample_SpatialAnchorsAccountResource
    {
        // List spatial anchors accounts by subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSpatialAnchorsAccounts_ListSpatialAnchorsAccountsBySubscription()
        {
            // Generated from example definition: specification/mixedreality/resource-manager/Microsoft.MixedReality/stable/2021-01-01/examples/spatial-anchors/GetBySubscription.json
            // this example is just showing the usage of "SpatialAnchorsAccounts_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (SpatialAnchorsAccountResource item in subscriptionResource.GetSpatialAnchorsAccountsAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SpatialAnchorsAccountData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Delete spatial anchors account
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteSpatialAnchorsAccount()
        {
            // Generated from example definition: specification/mixedreality/resource-manager/Microsoft.MixedReality/stable/2021-01-01/examples/spatial-anchors/Delete.json
            // this example is just showing the usage of "SpatialAnchorsAccounts_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SpatialAnchorsAccountResource created on azure
            // for more information of creating SpatialAnchorsAccountResource, please refer to the document of SpatialAnchorsAccountResource
            string subscriptionId = "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx";
            string resourceGroupName = "MyResourceGroup";
            string accountName = "MyAccount";
            ResourceIdentifier spatialAnchorsAccountResourceId = SpatialAnchorsAccountResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            SpatialAnchorsAccountResource spatialAnchorsAccount = client.GetSpatialAnchorsAccountResource(spatialAnchorsAccountResourceId);

            // invoke the operation
            await spatialAnchorsAccount.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Get spatial anchors account
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetSpatialAnchorsAccount()
        {
            // Generated from example definition: specification/mixedreality/resource-manager/Microsoft.MixedReality/stable/2021-01-01/examples/spatial-anchors/Get.json
            // this example is just showing the usage of "SpatialAnchorsAccounts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SpatialAnchorsAccountResource created on azure
            // for more information of creating SpatialAnchorsAccountResource, please refer to the document of SpatialAnchorsAccountResource
            string subscriptionId = "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx";
            string resourceGroupName = "MyResourceGroup";
            string accountName = "MyAccount";
            ResourceIdentifier spatialAnchorsAccountResourceId = SpatialAnchorsAccountResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            SpatialAnchorsAccountResource spatialAnchorsAccount = client.GetSpatialAnchorsAccountResource(spatialAnchorsAccountResourceId);

            // invoke the operation
            SpatialAnchorsAccountResource result = await spatialAnchorsAccount.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SpatialAnchorsAccountData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update spatial anchors account
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateSpatialAnchorsAccount()
        {
            // Generated from example definition: specification/mixedreality/resource-manager/Microsoft.MixedReality/stable/2021-01-01/examples/spatial-anchors/Patch.json
            // this example is just showing the usage of "SpatialAnchorsAccounts_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SpatialAnchorsAccountResource created on azure
            // for more information of creating SpatialAnchorsAccountResource, please refer to the document of SpatialAnchorsAccountResource
            string subscriptionId = "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx";
            string resourceGroupName = "MyResourceGroup";
            string accountName = "MyAccount";
            ResourceIdentifier spatialAnchorsAccountResourceId = SpatialAnchorsAccountResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            SpatialAnchorsAccountResource spatialAnchorsAccount = client.GetSpatialAnchorsAccountResource(spatialAnchorsAccountResourceId);

            // invoke the operation
            SpatialAnchorsAccountData data = new SpatialAnchorsAccountData(new AzureLocation("eastus2euap"))
            {
                Tags =
{
["hero"] = "romeo",
["heroine"] = "juliet",
},
            };
            SpatialAnchorsAccountResource result = await spatialAnchorsAccount.UpdateAsync(data);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SpatialAnchorsAccountData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // List spatial anchor account key
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetKeys_ListSpatialAnchorAccountKey()
        {
            // Generated from example definition: specification/mixedreality/resource-manager/Microsoft.MixedReality/stable/2021-01-01/examples/spatial-anchors/ListKeys.json
            // this example is just showing the usage of "SpatialAnchorsAccounts_ListKeys" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SpatialAnchorsAccountResource created on azure
            // for more information of creating SpatialAnchorsAccountResource, please refer to the document of SpatialAnchorsAccountResource
            string subscriptionId = "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx";
            string resourceGroupName = "MyResourceGroup";
            string accountName = "MyAccount";
            ResourceIdentifier spatialAnchorsAccountResourceId = SpatialAnchorsAccountResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            SpatialAnchorsAccountResource spatialAnchorsAccount = client.GetSpatialAnchorsAccountResource(spatialAnchorsAccountResourceId);

            // invoke the operation
            MixedRealityAccountKeys result = await spatialAnchorsAccount.GetKeysAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // Regenerate spatial anchors account keys
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task RegenerateKeys_RegenerateSpatialAnchorsAccountKeys()
        {
            // Generated from example definition: specification/mixedreality/resource-manager/Microsoft.MixedReality/stable/2021-01-01/examples/spatial-anchors/RegenerateKey.json
            // this example is just showing the usage of "SpatialAnchorsAccounts_RegenerateKeys" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SpatialAnchorsAccountResource created on azure
            // for more information of creating SpatialAnchorsAccountResource, please refer to the document of SpatialAnchorsAccountResource
            string subscriptionId = "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx";
            string resourceGroupName = "MyResourceGroup";
            string accountName = "MyAccount";
            ResourceIdentifier spatialAnchorsAccountResourceId = SpatialAnchorsAccountResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            SpatialAnchorsAccountResource spatialAnchorsAccount = client.GetSpatialAnchorsAccountResource(spatialAnchorsAccountResourceId);

            // invoke the operation
            MixedRealityAccountKeyRegenerateContent content = new MixedRealityAccountKeyRegenerateContent()
            {
                Serial = MixedRealityAccountKeySerial.Primary,
            };
            MixedRealityAccountKeys result = await spatialAnchorsAccount.RegenerateKeysAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
