// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.MixedReality.Common;

namespace Azure.MixedReality.Authentication
{
    /// <summary> Represents a token response message from the STS service. </summary>
    internal partial class StsTokenResponseMessage
    {
        /// <summary> Initializes a new instance of <see cref="StsTokenResponseMessage"/>. </summary>
        /// <param name="accessToken"> An access token for the account. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="accessToken"/> is null. </exception>
        internal StsTokenResponseMessage(string accessToken)
        {
            Argument.AssertNotNull(accessToken, nameof(accessToken));

            AccessToken = accessToken;
        }

        /// <summary> An access token for the account. </summary>
        public string AccessToken { get; }
    }
}
