// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.MixedReality.Authentication
{
    internal partial class StsTokenResponseMessage
    {
        internal static StsTokenResponseMessage DeserializeStsTokenResponseMessage(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string accessToken = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("AccessToken"u8))
                {
                    accessToken = property.Value.GetString();
                    continue;
                }
            }
            return new StsTokenResponseMessage(accessToken);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static StsTokenResponseMessage FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeStsTokenResponseMessage(document.RootElement);
        }
    }
}
