// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.MigrationDiscoverySap.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.MigrationDiscoverySap
{
    /// <summary>
    /// A class representing the SapInstance data model.
    /// Define the SAP Instance resource.
    /// </summary>
    public partial class SapInstanceData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SapInstanceData"/>. </summary>
        /// <param name="location"> The location. </param>
        public SapInstanceData(AzureLocation location) : base(location)
        {
        }

        /// <summary> Initializes a new instance of <see cref="SapInstanceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="systemSid"> This is the SID of SAP System. Keeping this not equal to ID as different landscapes can have repeated System SID IDs. </param>
        /// <param name="environment"> The Environment; PRD, QA, DEV, etc to which SAP system belongs to. Select from the list of available dropdown values. </param>
        /// <param name="landscapeSid"> This is the SID of the production system in a landscape.  An SAP system could itself be a production SID or a part of a landscape with a different Production SID. This field can be used to relate non-prod SIDs, other components, SID (WEBDISP) to the prod SID. Enter the value of Production SID. </param>
        /// <param name="application"> Enter a business function/department identifier to group multiple SIDs. </param>
        /// <param name="provisioningState"> Defines the provisioning states. </param>
        /// <param name="errors"> Defines the errors related to SAP Instance resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SapInstanceData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, string systemSid, SapInstanceEnvironment? environment, string landscapeSid, string application, SapDiscoveryProvisioningState? provisioningState, SapMigrateError errors, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            SystemSid = systemSid;
            Environment = environment;
            LandscapeSid = landscapeSid;
            Application = application;
            ProvisioningState = provisioningState;
            Errors = errors;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="SapInstanceData"/> for deserialization. </summary>
        internal SapInstanceData()
        {
        }

        /// <summary> This is the SID of SAP System. Keeping this not equal to ID as different landscapes can have repeated System SID IDs. </summary>
        public string SystemSid { get; }
        /// <summary> The Environment; PRD, QA, DEV, etc to which SAP system belongs to. Select from the list of available dropdown values. </summary>
        public SapInstanceEnvironment? Environment { get; }
        /// <summary> This is the SID of the production system in a landscape.  An SAP system could itself be a production SID or a part of a landscape with a different Production SID. This field can be used to relate non-prod SIDs, other components, SID (WEBDISP) to the prod SID. Enter the value of Production SID. </summary>
        public string LandscapeSid { get; }
        /// <summary> Enter a business function/department identifier to group multiple SIDs. </summary>
        public string Application { get; }
        /// <summary> Defines the provisioning states. </summary>
        public SapDiscoveryProvisioningState? ProvisioningState { get; }
        /// <summary> Defines the errors related to SAP Instance resource. </summary>
        public SapMigrateError Errors { get; }
    }
}
