// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.MigrationDiscoverySap
{
    /// <summary>
    /// A class representing a collection of <see cref="SapInstanceResource"/> and their operations.
    /// Each <see cref="SapInstanceResource"/> in the collection will belong to the same instance of <see cref="SapDiscoverySiteResource"/>.
    /// To get a <see cref="SapInstanceCollection"/> instance call the GetSapInstances method from an instance of <see cref="SapDiscoverySiteResource"/>.
    /// </summary>
    public partial class SapInstanceCollection : ArmCollection, IEnumerable<SapInstanceResource>, IAsyncEnumerable<SapInstanceResource>
    {
        private readonly ClientDiagnostics _sapInstanceClientDiagnostics;
        private readonly SapInstancesRestOperations _sapInstanceRestClient;

        /// <summary> Initializes a new instance of the <see cref="SapInstanceCollection"/> class for mocking. </summary>
        protected SapInstanceCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SapInstanceCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SapInstanceCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _sapInstanceClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.MigrationDiscoverySap", SapInstanceResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SapInstanceResource.ResourceType, out string sapInstanceApiVersion);
            _sapInstanceRestClient = new SapInstancesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, sapInstanceApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SapDiscoverySiteResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SapDiscoverySiteResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates the SAP Instance resource. &lt;br&gt;&lt;br&gt;This will be used by service only. PUT operation on this resource by end user will return a Bad Request error.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}/sapInstances/{sapInstanceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SapInstances_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SapInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="sapInstanceName"> The name of SAP Instance resource for SAP Migration. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="sapInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="sapInstanceName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<SapInstanceResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string sapInstanceName, SapInstanceData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(sapInstanceName, nameof(sapInstanceName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _sapInstanceClientDiagnostics.CreateScope("SapInstanceCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _sapInstanceRestClient.CreateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, sapInstanceName, data, cancellationToken).ConfigureAwait(false);
                var operation = new MigrationDiscoverySapArmOperation<SapInstanceResource>(new SapInstanceOperationSource(Client), _sapInstanceClientDiagnostics, Pipeline, _sapInstanceRestClient.CreateCreateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, sapInstanceName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates the SAP Instance resource. &lt;br&gt;&lt;br&gt;This will be used by service only. PUT operation on this resource by end user will return a Bad Request error.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}/sapInstances/{sapInstanceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SapInstances_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SapInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="sapInstanceName"> The name of SAP Instance resource for SAP Migration. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="sapInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="sapInstanceName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<SapInstanceResource> CreateOrUpdate(WaitUntil waitUntil, string sapInstanceName, SapInstanceData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(sapInstanceName, nameof(sapInstanceName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _sapInstanceClientDiagnostics.CreateScope("SapInstanceCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _sapInstanceRestClient.Create(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, sapInstanceName, data, cancellationToken);
                var operation = new MigrationDiscoverySapArmOperation<SapInstanceResource>(new SapInstanceOperationSource(Client), _sapInstanceClientDiagnostics, Pipeline, _sapInstanceRestClient.CreateCreateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, sapInstanceName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the SAP Instance resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}/sapInstances/{sapInstanceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SapInstances_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SapInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sapInstanceName"> The name of SAP Instance resource for SAP Migration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="sapInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="sapInstanceName"/> is null. </exception>
        public virtual async Task<Response<SapInstanceResource>> GetAsync(string sapInstanceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(sapInstanceName, nameof(sapInstanceName));

            using var scope = _sapInstanceClientDiagnostics.CreateScope("SapInstanceCollection.Get");
            scope.Start();
            try
            {
                var response = await _sapInstanceRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, sapInstanceName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SapInstanceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the SAP Instance resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}/sapInstances/{sapInstanceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SapInstances_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SapInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sapInstanceName"> The name of SAP Instance resource for SAP Migration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="sapInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="sapInstanceName"/> is null. </exception>
        public virtual Response<SapInstanceResource> Get(string sapInstanceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(sapInstanceName, nameof(sapInstanceName));

            using var scope = _sapInstanceClientDiagnostics.CreateScope("SapInstanceCollection.Get");
            scope.Start();
            try
            {
                var response = _sapInstanceRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, sapInstanceName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SapInstanceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists the SAP Instance resources for the given SAP Migration discovery site resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}/sapInstances</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SapInstances_ListBySapDiscoverySite</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SapInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SapInstanceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SapInstanceResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sapInstanceRestClient.CreateListBySapDiscoverySiteRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _sapInstanceRestClient.CreateListBySapDiscoverySiteNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SapInstanceResource(Client, SapInstanceData.DeserializeSapInstanceData(e)), _sapInstanceClientDiagnostics, Pipeline, "SapInstanceCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the SAP Instance resources for the given SAP Migration discovery site resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}/sapInstances</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SapInstances_ListBySapDiscoverySite</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SapInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SapInstanceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SapInstanceResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sapInstanceRestClient.CreateListBySapDiscoverySiteRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _sapInstanceRestClient.CreateListBySapDiscoverySiteNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SapInstanceResource(Client, SapInstanceData.DeserializeSapInstanceData(e)), _sapInstanceClientDiagnostics, Pipeline, "SapInstanceCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}/sapInstances/{sapInstanceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SapInstances_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SapInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sapInstanceName"> The name of SAP Instance resource for SAP Migration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="sapInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="sapInstanceName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string sapInstanceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(sapInstanceName, nameof(sapInstanceName));

            using var scope = _sapInstanceClientDiagnostics.CreateScope("SapInstanceCollection.Exists");
            scope.Start();
            try
            {
                var response = await _sapInstanceRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, sapInstanceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}/sapInstances/{sapInstanceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SapInstances_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SapInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sapInstanceName"> The name of SAP Instance resource for SAP Migration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="sapInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="sapInstanceName"/> is null. </exception>
        public virtual Response<bool> Exists(string sapInstanceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(sapInstanceName, nameof(sapInstanceName));

            using var scope = _sapInstanceClientDiagnostics.CreateScope("SapInstanceCollection.Exists");
            scope.Start();
            try
            {
                var response = _sapInstanceRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, sapInstanceName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}/sapInstances/{sapInstanceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SapInstances_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SapInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sapInstanceName"> The name of SAP Instance resource for SAP Migration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="sapInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="sapInstanceName"/> is null. </exception>
        public virtual async Task<NullableResponse<SapInstanceResource>> GetIfExistsAsync(string sapInstanceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(sapInstanceName, nameof(sapInstanceName));

            using var scope = _sapInstanceClientDiagnostics.CreateScope("SapInstanceCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _sapInstanceRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, sapInstanceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SapInstanceResource>(response.GetRawResponse());
                return Response.FromValue(new SapInstanceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}/sapInstances/{sapInstanceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SapInstances_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SapInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sapInstanceName"> The name of SAP Instance resource for SAP Migration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="sapInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="sapInstanceName"/> is null. </exception>
        public virtual NullableResponse<SapInstanceResource> GetIfExists(string sapInstanceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(sapInstanceName, nameof(sapInstanceName));

            using var scope = _sapInstanceClientDiagnostics.CreateScope("SapInstanceCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _sapInstanceRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, sapInstanceName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SapInstanceResource>(response.GetRawResponse());
                return Response.FromValue(new SapInstanceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SapInstanceResource> IEnumerable<SapInstanceResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SapInstanceResource> IAsyncEnumerable<SapInstanceResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
