// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.MigrationDiscoverySap.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.MigrationDiscoverySap
{
    /// <summary>
    /// A class representing the SapDiscoverySite data model.
    /// Define the SAP Migration discovery site resource.
    /// </summary>
    public partial class SapDiscoverySiteData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SapDiscoverySiteData"/>. </summary>
        /// <param name="location"> The location. </param>
        public SapDiscoverySiteData(AzureLocation location) : base(location)
        {
        }

        /// <summary> Initializes a new instance of <see cref="SapDiscoverySiteData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="extendedLocation"> The extended location definition. </param>
        /// <param name="masterSiteId"> The master site ID from Azure Migrate. </param>
        /// <param name="migrateProjectId"> The migrate project ID from Azure Migrate. </param>
        /// <param name="provisioningState"> Defines the provisioning states. </param>
        /// <param name="errors"> Indicates any errors on the SAP Migration discovery site resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SapDiscoverySiteData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, SapDiscoveryExtendedLocation extendedLocation, string masterSiteId, string migrateProjectId, SapDiscoveryProvisioningState? provisioningState, SapMigrateError errors, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            ExtendedLocation = extendedLocation;
            MasterSiteId = masterSiteId;
            MigrateProjectId = migrateProjectId;
            ProvisioningState = provisioningState;
            Errors = errors;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="SapDiscoverySiteData"/> for deserialization. </summary>
        internal SapDiscoverySiteData()
        {
        }

        /// <summary> The extended location definition. </summary>
        public SapDiscoveryExtendedLocation ExtendedLocation { get; set; }
        /// <summary> The master site ID from Azure Migrate. </summary>
        public string MasterSiteId { get; set; }
        /// <summary> The migrate project ID from Azure Migrate. </summary>
        public string MigrateProjectId { get; set; }
        /// <summary> Defines the provisioning states. </summary>
        public SapDiscoveryProvisioningState? ProvisioningState { get; }
        /// <summary> Indicates any errors on the SAP Migration discovery site resource. </summary>
        public SapMigrateError Errors { get; }
    }
}
