// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.MigrationDiscoverySap.Models;

namespace Azure.ResourceManager.MigrationDiscoverySap
{
    internal partial class ServerInstancesRestOperations
    {
        private readonly TelemetryDetails _userAgent;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> Initializes a new instance of ServerInstancesRestOperations. </summary>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="applicationId"> The application id to use for user agent. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public ServerInstancesRestOperations(HttpPipeline pipeline, string applicationId, Uri endpoint = null, string apiVersion = default)
        {
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://management.azure.com");
            _apiVersion = apiVersion ?? "2023-10-01-preview";
            _userAgent = new TelemetryDetails(GetType().Assembly, applicationId);
        }

        internal RequestUriBuilder CreateListBySapInstanceRequestUri(string subscriptionId, string resourceGroupName, string sapDiscoverySiteName, string sapInstanceName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Workloads/sapDiscoverySites/", false);
            uri.AppendPath(sapDiscoverySiteName, true);
            uri.AppendPath("/sapInstances/", false);
            uri.AppendPath(sapInstanceName, true);
            uri.AppendPath("/serverInstances", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateListBySapInstanceRequest(string subscriptionId, string resourceGroupName, string sapDiscoverySiteName, string sapInstanceName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Workloads/sapDiscoverySites/", false);
            uri.AppendPath(sapDiscoverySiteName, true);
            uri.AppendPath("/sapInstances/", false);
            uri.AppendPath(sapInstanceName, true);
            uri.AppendPath("/serverInstances", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Lists the Server Instance resources for the given SAP Instance resource. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="sapDiscoverySiteName"> The name of the discovery site resource for SAP Migration. </param>
        /// <param name="sapInstanceName"> The name of SAP Instance resource for SAP Migration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="sapDiscoverySiteName"/> or <paramref name="sapInstanceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="sapDiscoverySiteName"/> or <paramref name="sapInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<ServerInstanceListResult>> ListBySapInstanceAsync(string subscriptionId, string resourceGroupName, string sapDiscoverySiteName, string sapInstanceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(sapDiscoverySiteName, nameof(sapDiscoverySiteName));
            Argument.AssertNotNullOrEmpty(sapInstanceName, nameof(sapInstanceName));

            using var message = CreateListBySapInstanceRequest(subscriptionId, resourceGroupName, sapDiscoverySiteName, sapInstanceName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ServerInstanceListResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = ServerInstanceListResult.DeserializeServerInstanceListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Lists the Server Instance resources for the given SAP Instance resource. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="sapDiscoverySiteName"> The name of the discovery site resource for SAP Migration. </param>
        /// <param name="sapInstanceName"> The name of SAP Instance resource for SAP Migration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="sapDiscoverySiteName"/> or <paramref name="sapInstanceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="sapDiscoverySiteName"/> or <paramref name="sapInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<ServerInstanceListResult> ListBySapInstance(string subscriptionId, string resourceGroupName, string sapDiscoverySiteName, string sapInstanceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(sapDiscoverySiteName, nameof(sapDiscoverySiteName));
            Argument.AssertNotNullOrEmpty(sapInstanceName, nameof(sapInstanceName));

            using var message = CreateListBySapInstanceRequest(subscriptionId, resourceGroupName, sapDiscoverySiteName, sapInstanceName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ServerInstanceListResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = ServerInstanceListResult.DeserializeServerInstanceListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateGetRequestUri(string subscriptionId, string resourceGroupName, string sapDiscoverySiteName, string sapInstanceName, string serverInstanceName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Workloads/sapDiscoverySites/", false);
            uri.AppendPath(sapDiscoverySiteName, true);
            uri.AppendPath("/sapInstances/", false);
            uri.AppendPath(sapInstanceName, true);
            uri.AppendPath("/serverInstances/", false);
            uri.AppendPath(serverInstanceName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateGetRequest(string subscriptionId, string resourceGroupName, string sapDiscoverySiteName, string sapInstanceName, string serverInstanceName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Workloads/sapDiscoverySites/", false);
            uri.AppendPath(sapDiscoverySiteName, true);
            uri.AppendPath("/sapInstances/", false);
            uri.AppendPath(sapInstanceName, true);
            uri.AppendPath("/serverInstances/", false);
            uri.AppendPath(serverInstanceName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Gets the Server Instance resource. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="sapDiscoverySiteName"> The name of the discovery site resource for SAP Migration. </param>
        /// <param name="sapInstanceName"> The name of SAP Instance resource for SAP Migration. </param>
        /// <param name="serverInstanceName"> The name of the Server instance resource for SAP Migration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="sapDiscoverySiteName"/>, <paramref name="sapInstanceName"/> or <paramref name="serverInstanceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="sapDiscoverySiteName"/>, <paramref name="sapInstanceName"/> or <paramref name="serverInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<SapDiscoveryServerInstanceData>> GetAsync(string subscriptionId, string resourceGroupName, string sapDiscoverySiteName, string sapInstanceName, string serverInstanceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(sapDiscoverySiteName, nameof(sapDiscoverySiteName));
            Argument.AssertNotNullOrEmpty(sapInstanceName, nameof(sapInstanceName));
            Argument.AssertNotNullOrEmpty(serverInstanceName, nameof(serverInstanceName));

            using var message = CreateGetRequest(subscriptionId, resourceGroupName, sapDiscoverySiteName, sapInstanceName, serverInstanceName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SapDiscoveryServerInstanceData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SapDiscoveryServerInstanceData.DeserializeSapDiscoveryServerInstanceData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((SapDiscoveryServerInstanceData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets the Server Instance resource. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="sapDiscoverySiteName"> The name of the discovery site resource for SAP Migration. </param>
        /// <param name="sapInstanceName"> The name of SAP Instance resource for SAP Migration. </param>
        /// <param name="serverInstanceName"> The name of the Server instance resource for SAP Migration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="sapDiscoverySiteName"/>, <paramref name="sapInstanceName"/> or <paramref name="serverInstanceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="sapDiscoverySiteName"/>, <paramref name="sapInstanceName"/> or <paramref name="serverInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<SapDiscoveryServerInstanceData> Get(string subscriptionId, string resourceGroupName, string sapDiscoverySiteName, string sapInstanceName, string serverInstanceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(sapDiscoverySiteName, nameof(sapDiscoverySiteName));
            Argument.AssertNotNullOrEmpty(sapInstanceName, nameof(sapInstanceName));
            Argument.AssertNotNullOrEmpty(serverInstanceName, nameof(serverInstanceName));

            using var message = CreateGetRequest(subscriptionId, resourceGroupName, sapDiscoverySiteName, sapInstanceName, serverInstanceName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SapDiscoveryServerInstanceData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SapDiscoveryServerInstanceData.DeserializeSapDiscoveryServerInstanceData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((SapDiscoveryServerInstanceData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateCreateRequestUri(string subscriptionId, string resourceGroupName, string sapDiscoverySiteName, string sapInstanceName, string serverInstanceName, SapDiscoveryServerInstanceData data)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Workloads/sapDiscoverySites/", false);
            uri.AppendPath(sapDiscoverySiteName, true);
            uri.AppendPath("/sapInstances/", false);
            uri.AppendPath(sapInstanceName, true);
            uri.AppendPath("/serverInstances/", false);
            uri.AppendPath(serverInstanceName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateCreateRequest(string subscriptionId, string resourceGroupName, string sapDiscoverySiteName, string sapInstanceName, string serverInstanceName, SapDiscoveryServerInstanceData data)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Workloads/sapDiscoverySites/", false);
            uri.AppendPath(sapDiscoverySiteName, true);
            uri.AppendPath("/sapInstances/", false);
            uri.AppendPath(sapInstanceName, true);
            uri.AppendPath("/serverInstances/", false);
            uri.AppendPath(serverInstanceName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(data, ModelSerializationExtensions.WireOptions);
            request.Content = content;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Creates the Server Instance resource. &lt;br&gt;&lt;br&gt;;This will be used by service only. PUT operation on this resource by end user will return a Bad Request error. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="sapDiscoverySiteName"> The name of the discovery site resource for SAP Migration. </param>
        /// <param name="sapInstanceName"> The name of SAP Instance resource for SAP Migration. </param>
        /// <param name="serverInstanceName"> The name of the Server instance resource for SAP Migration. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="sapDiscoverySiteName"/>, <paramref name="sapInstanceName"/>, <paramref name="serverInstanceName"/> or <paramref name="data"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="sapDiscoverySiteName"/>, <paramref name="sapInstanceName"/> or <paramref name="serverInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response> CreateAsync(string subscriptionId, string resourceGroupName, string sapDiscoverySiteName, string sapInstanceName, string serverInstanceName, SapDiscoveryServerInstanceData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(sapDiscoverySiteName, nameof(sapDiscoverySiteName));
            Argument.AssertNotNullOrEmpty(sapInstanceName, nameof(sapInstanceName));
            Argument.AssertNotNullOrEmpty(serverInstanceName, nameof(serverInstanceName));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateCreateRequest(subscriptionId, resourceGroupName, sapDiscoverySiteName, sapInstanceName, serverInstanceName, data);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                case 201:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Creates the Server Instance resource. &lt;br&gt;&lt;br&gt;;This will be used by service only. PUT operation on this resource by end user will return a Bad Request error. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="sapDiscoverySiteName"> The name of the discovery site resource for SAP Migration. </param>
        /// <param name="sapInstanceName"> The name of SAP Instance resource for SAP Migration. </param>
        /// <param name="serverInstanceName"> The name of the Server instance resource for SAP Migration. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="sapDiscoverySiteName"/>, <paramref name="sapInstanceName"/>, <paramref name="serverInstanceName"/> or <paramref name="data"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="sapDiscoverySiteName"/>, <paramref name="sapInstanceName"/> or <paramref name="serverInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response Create(string subscriptionId, string resourceGroupName, string sapDiscoverySiteName, string sapInstanceName, string serverInstanceName, SapDiscoveryServerInstanceData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(sapDiscoverySiteName, nameof(sapDiscoverySiteName));
            Argument.AssertNotNullOrEmpty(sapInstanceName, nameof(sapInstanceName));
            Argument.AssertNotNullOrEmpty(serverInstanceName, nameof(serverInstanceName));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateCreateRequest(subscriptionId, resourceGroupName, sapDiscoverySiteName, sapInstanceName, serverInstanceName, data);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                case 201:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateUpdateRequestUri(string subscriptionId, string resourceGroupName, string sapDiscoverySiteName, string sapInstanceName, string serverInstanceName, SapDiscoveryServerInstancePatch patch)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Workloads/sapDiscoverySites/", false);
            uri.AppendPath(sapDiscoverySiteName, true);
            uri.AppendPath("/sapInstances/", false);
            uri.AppendPath(sapInstanceName, true);
            uri.AppendPath("/serverInstances/", false);
            uri.AppendPath(serverInstanceName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateUpdateRequest(string subscriptionId, string resourceGroupName, string sapDiscoverySiteName, string sapInstanceName, string serverInstanceName, SapDiscoveryServerInstancePatch patch)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Patch;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Workloads/sapDiscoverySites/", false);
            uri.AppendPath(sapDiscoverySiteName, true);
            uri.AppendPath("/sapInstances/", false);
            uri.AppendPath(sapInstanceName, true);
            uri.AppendPath("/serverInstances/", false);
            uri.AppendPath(serverInstanceName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(patch, ModelSerializationExtensions.WireOptions);
            request.Content = content;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Updates the Server Instance resource. This operation on a resource by end user will return a Bad Request error. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="sapDiscoverySiteName"> The name of the discovery site resource for SAP Migration. </param>
        /// <param name="sapInstanceName"> The name of SAP Instance resource for SAP Migration. </param>
        /// <param name="serverInstanceName"> The name of the Server instance resource for SAP Migration. </param>
        /// <param name="patch"> The resource properties to be updated. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="sapDiscoverySiteName"/>, <paramref name="sapInstanceName"/>, <paramref name="serverInstanceName"/> or <paramref name="patch"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="sapDiscoverySiteName"/>, <paramref name="sapInstanceName"/> or <paramref name="serverInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<SapDiscoveryServerInstanceData>> UpdateAsync(string subscriptionId, string resourceGroupName, string sapDiscoverySiteName, string sapInstanceName, string serverInstanceName, SapDiscoveryServerInstancePatch patch, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(sapDiscoverySiteName, nameof(sapDiscoverySiteName));
            Argument.AssertNotNullOrEmpty(sapInstanceName, nameof(sapInstanceName));
            Argument.AssertNotNullOrEmpty(serverInstanceName, nameof(serverInstanceName));
            Argument.AssertNotNull(patch, nameof(patch));

            using var message = CreateUpdateRequest(subscriptionId, resourceGroupName, sapDiscoverySiteName, sapInstanceName, serverInstanceName, patch);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SapDiscoveryServerInstanceData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SapDiscoveryServerInstanceData.DeserializeSapDiscoveryServerInstanceData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Updates the Server Instance resource. This operation on a resource by end user will return a Bad Request error. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="sapDiscoverySiteName"> The name of the discovery site resource for SAP Migration. </param>
        /// <param name="sapInstanceName"> The name of SAP Instance resource for SAP Migration. </param>
        /// <param name="serverInstanceName"> The name of the Server instance resource for SAP Migration. </param>
        /// <param name="patch"> The resource properties to be updated. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="sapDiscoverySiteName"/>, <paramref name="sapInstanceName"/>, <paramref name="serverInstanceName"/> or <paramref name="patch"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="sapDiscoverySiteName"/>, <paramref name="sapInstanceName"/> or <paramref name="serverInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<SapDiscoveryServerInstanceData> Update(string subscriptionId, string resourceGroupName, string sapDiscoverySiteName, string sapInstanceName, string serverInstanceName, SapDiscoveryServerInstancePatch patch, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(sapDiscoverySiteName, nameof(sapDiscoverySiteName));
            Argument.AssertNotNullOrEmpty(sapInstanceName, nameof(sapInstanceName));
            Argument.AssertNotNullOrEmpty(serverInstanceName, nameof(serverInstanceName));
            Argument.AssertNotNull(patch, nameof(patch));

            using var message = CreateUpdateRequest(subscriptionId, resourceGroupName, sapDiscoverySiteName, sapInstanceName, serverInstanceName, patch);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SapDiscoveryServerInstanceData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SapDiscoveryServerInstanceData.DeserializeSapDiscoveryServerInstanceData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateDeleteRequestUri(string subscriptionId, string resourceGroupName, string sapDiscoverySiteName, string sapInstanceName, string serverInstanceName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Workloads/sapDiscoverySites/", false);
            uri.AppendPath(sapDiscoverySiteName, true);
            uri.AppendPath("/sapInstances/", false);
            uri.AppendPath(sapInstanceName, true);
            uri.AppendPath("/serverInstances/", false);
            uri.AppendPath(serverInstanceName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateDeleteRequest(string subscriptionId, string resourceGroupName, string sapDiscoverySiteName, string sapInstanceName, string serverInstanceName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Workloads/sapDiscoverySites/", false);
            uri.AppendPath(sapDiscoverySiteName, true);
            uri.AppendPath("/sapInstances/", false);
            uri.AppendPath(sapInstanceName, true);
            uri.AppendPath("/serverInstances/", false);
            uri.AppendPath(serverInstanceName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Deletes the Server Instance resource. &lt;br&gt;&lt;br&gt;;This will be used by service only. Delete operation on this resource by end user will return a Bad Request error. You can delete the parent resource, which is the SAP Migration discovery site resource, using the delete operation on it. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="sapDiscoverySiteName"> The name of the discovery site resource for SAP Migration. </param>
        /// <param name="sapInstanceName"> The name of SAP Instance resource for SAP Migration. </param>
        /// <param name="serverInstanceName"> The name of the Server instance resource for SAP Migration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="sapDiscoverySiteName"/>, <paramref name="sapInstanceName"/> or <paramref name="serverInstanceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="sapDiscoverySiteName"/>, <paramref name="sapInstanceName"/> or <paramref name="serverInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response> DeleteAsync(string subscriptionId, string resourceGroupName, string sapDiscoverySiteName, string sapInstanceName, string serverInstanceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(sapDiscoverySiteName, nameof(sapDiscoverySiteName));
            Argument.AssertNotNullOrEmpty(sapInstanceName, nameof(sapInstanceName));
            Argument.AssertNotNullOrEmpty(serverInstanceName, nameof(serverInstanceName));

            using var message = CreateDeleteRequest(subscriptionId, resourceGroupName, sapDiscoverySiteName, sapInstanceName, serverInstanceName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Deletes the Server Instance resource. &lt;br&gt;&lt;br&gt;;This will be used by service only. Delete operation on this resource by end user will return a Bad Request error. You can delete the parent resource, which is the SAP Migration discovery site resource, using the delete operation on it. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="sapDiscoverySiteName"> The name of the discovery site resource for SAP Migration. </param>
        /// <param name="sapInstanceName"> The name of SAP Instance resource for SAP Migration. </param>
        /// <param name="serverInstanceName"> The name of the Server instance resource for SAP Migration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="sapDiscoverySiteName"/>, <paramref name="sapInstanceName"/> or <paramref name="serverInstanceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="sapDiscoverySiteName"/>, <paramref name="sapInstanceName"/> or <paramref name="serverInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response Delete(string subscriptionId, string resourceGroupName, string sapDiscoverySiteName, string sapInstanceName, string serverInstanceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(sapDiscoverySiteName, nameof(sapDiscoverySiteName));
            Argument.AssertNotNullOrEmpty(sapInstanceName, nameof(sapInstanceName));
            Argument.AssertNotNullOrEmpty(serverInstanceName, nameof(serverInstanceName));

            using var message = CreateDeleteRequest(subscriptionId, resourceGroupName, sapDiscoverySiteName, sapInstanceName, serverInstanceName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListBySapInstanceNextPageRequestUri(string nextLink, string subscriptionId, string resourceGroupName, string sapDiscoverySiteName, string sapInstanceName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            return uri;
        }

        internal HttpMessage CreateListBySapInstanceNextPageRequest(string nextLink, string subscriptionId, string resourceGroupName, string sapDiscoverySiteName, string sapInstanceName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Lists the Server Instance resources for the given SAP Instance resource. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="sapDiscoverySiteName"> The name of the discovery site resource for SAP Migration. </param>
        /// <param name="sapInstanceName"> The name of SAP Instance resource for SAP Migration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="sapDiscoverySiteName"/> or <paramref name="sapInstanceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="sapDiscoverySiteName"/> or <paramref name="sapInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<ServerInstanceListResult>> ListBySapInstanceNextPageAsync(string nextLink, string subscriptionId, string resourceGroupName, string sapDiscoverySiteName, string sapInstanceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(sapDiscoverySiteName, nameof(sapDiscoverySiteName));
            Argument.AssertNotNullOrEmpty(sapInstanceName, nameof(sapInstanceName));

            using var message = CreateListBySapInstanceNextPageRequest(nextLink, subscriptionId, resourceGroupName, sapDiscoverySiteName, sapInstanceName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ServerInstanceListResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = ServerInstanceListResult.DeserializeServerInstanceListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Lists the Server Instance resources for the given SAP Instance resource. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="sapDiscoverySiteName"> The name of the discovery site resource for SAP Migration. </param>
        /// <param name="sapInstanceName"> The name of SAP Instance resource for SAP Migration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="sapDiscoverySiteName"/> or <paramref name="sapInstanceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="sapDiscoverySiteName"/> or <paramref name="sapInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<ServerInstanceListResult> ListBySapInstanceNextPage(string nextLink, string subscriptionId, string resourceGroupName, string sapDiscoverySiteName, string sapInstanceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(sapDiscoverySiteName, nameof(sapDiscoverySiteName));
            Argument.AssertNotNullOrEmpty(sapInstanceName, nameof(sapInstanceName));

            using var message = CreateListBySapInstanceNextPageRequest(nextLink, subscriptionId, resourceGroupName, sapDiscoverySiteName, sapInstanceName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ServerInstanceListResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = ServerInstanceListResult.DeserializeServerInstanceListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
