// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MigrationDiscoverySap.Models
{
    public partial class ServerInstanceProperties : IUtf8JsonSerializable, IJsonModel<ServerInstanceProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ServerInstanceProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ServerInstanceProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerInstanceProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ServerInstanceProperties)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(ServerName))
            {
                writer.WritePropertyName("serverName"u8);
                writer.WriteStringValue(ServerName);
            }
            if (options.Format != "W" && Optional.IsDefined(SapInstanceType))
            {
                writer.WritePropertyName("sapInstanceType"u8);
                writer.WriteStringValue(SapInstanceType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(InstanceSid))
            {
                writer.WritePropertyName("instanceSid"u8);
                writer.WriteStringValue(InstanceSid);
            }
            if (options.Format != "W" && Optional.IsDefined(SapProduct))
            {
                writer.WritePropertyName("sapProduct"u8);
                writer.WriteStringValue(SapProduct);
            }
            if (options.Format != "W" && Optional.IsDefined(SapProductVersion))
            {
                writer.WritePropertyName("sapProductVersion"u8);
                writer.WriteStringValue(SapProductVersion);
            }
            if (options.Format != "W" && Optional.IsDefined(OperatingSystem))
            {
                writer.WritePropertyName("operatingSystem"u8);
                writer.WriteStringValue(OperatingSystem.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ConfigurationData))
            {
                writer.WritePropertyName("configurationData"u8);
                writer.WriteObjectValue(ConfigurationData, options);
            }
            if (options.Format != "W" && Optional.IsDefined(PerformanceData))
            {
                writer.WritePropertyName("performanceData"u8);
                writer.WriteObjectValue(PerformanceData, options);
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(Errors))
            {
                writer.WritePropertyName("errors"u8);
                writer.WriteObjectValue(Errors, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ServerInstanceProperties IJsonModel<ServerInstanceProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerInstanceProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ServerInstanceProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeServerInstanceProperties(document.RootElement, options);
        }

        internal static ServerInstanceProperties DeserializeServerInstanceProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string serverName = default;
            SapInstanceType? sapInstanceType = default;
            string instanceSid = default;
            string sapProduct = default;
            string sapProductVersion = default;
            SapDiscoveryOperatingSystem? operatingSystem = default;
            ConfigurationDetail configurationData = default;
            PerformanceDetail performanceData = default;
            SapDiscoveryProvisioningState? provisioningState = default;
            SapMigrateError errors = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("serverName"u8))
                {
                    serverName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sapInstanceType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sapInstanceType = new SapInstanceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("instanceSid"u8))
                {
                    instanceSid = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sapProduct"u8))
                {
                    sapProduct = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sapProductVersion"u8))
                {
                    sapProductVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("operatingSystem"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    operatingSystem = new SapDiscoveryOperatingSystem(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("configurationData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    configurationData = ConfigurationDetail.DeserializeConfigurationDetail(property.Value, options);
                    continue;
                }
                if (property.NameEquals("performanceData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    performanceData = PerformanceDetail.DeserializePerformanceDetail(property.Value, options);
                    continue;
                }
                if (property.NameEquals("provisioningState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    provisioningState = new SapDiscoveryProvisioningState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("errors"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    errors = SapMigrateError.DeserializeSapMigrateError(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ServerInstanceProperties(
                serverName,
                sapInstanceType,
                instanceSid,
                sapProduct,
                sapProductVersion,
                operatingSystem,
                configurationData,
                performanceData,
                provisioningState,
                errors,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ServerInstanceProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerInstanceProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ServerInstanceProperties)} does not support writing '{options.Format}' format.");
            }
        }

        ServerInstanceProperties IPersistableModel<ServerInstanceProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerInstanceProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeServerInstanceProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ServerInstanceProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ServerInstanceProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
