// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MigrationDiscoverySap.Models
{
    /// <summary> The SAP instance type running on this machine, e.g., App, ASCS, DB, etc. Select from the list of available dropdown values. Only single server and distributed architectures are supported. </summary>
    public readonly partial struct SapInstanceType : IEquatable<SapInstanceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SapInstanceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SapInstanceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AscsValue = "ASCS";
        private const string DBValue = "DB";
        private const string AppValue = "APP";
        private const string ScsValue = "SCS";
        private const string WebdispValue = "WEBDISP";

        /// <summary> The type of Sap Instance- ASCS. </summary>
        public static SapInstanceType Ascs { get; } = new SapInstanceType(AscsValue);
        /// <summary> The type of Sap Instance- DB. </summary>
        public static SapInstanceType DB { get; } = new SapInstanceType(DBValue);
        /// <summary> The type of Sap Instance- APP. </summary>
        public static SapInstanceType App { get; } = new SapInstanceType(AppValue);
        /// <summary> The type of Sap Instance- SCS. </summary>
        public static SapInstanceType Scs { get; } = new SapInstanceType(ScsValue);
        /// <summary> The type of Sap Instance- WEBDISP. </summary>
        public static SapInstanceType Webdisp { get; } = new SapInstanceType(WebdispValue);
        /// <summary> Determines if two <see cref="SapInstanceType"/> values are the same. </summary>
        public static bool operator ==(SapInstanceType left, SapInstanceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SapInstanceType"/> values are not the same. </summary>
        public static bool operator !=(SapInstanceType left, SapInstanceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SapInstanceType"/>. </summary>
        public static implicit operator SapInstanceType(string value) => new SapInstanceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SapInstanceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SapInstanceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
