// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MigrationDiscoverySap.Models
{
    /// <summary> This is Operating System on which the host server is running. </summary>
    public readonly partial struct SapDiscoveryOperatingSystem : IEquatable<SapDiscoveryOperatingSystem>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SapDiscoveryOperatingSystem"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SapDiscoveryOperatingSystem(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IbmAixValue = "IBMAIX";
        private const string RedHatValue = "RedHat";
        private const string SuseValue = "SUSE";
        private const string SolarisValue = "Solaris";
        private const string UnixValue = "Unix";
        private const string WindowsServerValue = "WindowsServer";

        /// <summary> The type of Operating system- IBMAIX. </summary>
        public static SapDiscoveryOperatingSystem IbmAix { get; } = new SapDiscoveryOperatingSystem(IbmAixValue);
        /// <summary> The type of Operating system- RedHat. </summary>
        public static SapDiscoveryOperatingSystem RedHat { get; } = new SapDiscoveryOperatingSystem(RedHatValue);
        /// <summary> The type of Operating system- SUSE. </summary>
        public static SapDiscoveryOperatingSystem Suse { get; } = new SapDiscoveryOperatingSystem(SuseValue);
        /// <summary> The type of Operating system- Solaris. </summary>
        public static SapDiscoveryOperatingSystem Solaris { get; } = new SapDiscoveryOperatingSystem(SolarisValue);
        /// <summary> The type of Operating system- Unix. </summary>
        public static SapDiscoveryOperatingSystem Unix { get; } = new SapDiscoveryOperatingSystem(UnixValue);
        /// <summary> The type of Operating system- WindowsServer. </summary>
        public static SapDiscoveryOperatingSystem WindowsServer { get; } = new SapDiscoveryOperatingSystem(WindowsServerValue);
        /// <summary> Determines if two <see cref="SapDiscoveryOperatingSystem"/> values are the same. </summary>
        public static bool operator ==(SapDiscoveryOperatingSystem left, SapDiscoveryOperatingSystem right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SapDiscoveryOperatingSystem"/> values are not the same. </summary>
        public static bool operator !=(SapDiscoveryOperatingSystem left, SapDiscoveryOperatingSystem right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SapDiscoveryOperatingSystem"/>. </summary>
        public static implicit operator SapDiscoveryOperatingSystem(string value) => new SapDiscoveryOperatingSystem(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SapDiscoveryOperatingSystem other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SapDiscoveryOperatingSystem other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
